/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.bedframe.geyser;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.zip.ZipFile;
import lol.sylvie.bedframe.geyser.PackGenerator;
import lol.sylvie.bedframe.geyser.Translator;
import lol.sylvie.bedframe.geyser.translator.BlockTranslator;
import lol.sylvie.bedframe.geyser.translator.ItemTranslator;
import lol.sylvie.bedframe.util.BedframeConstants;
import lol.sylvie.bedframe.util.ResourceHelper;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.event.EventBus;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineResourcePacksEvent;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;
import org.geysermc.pack.converter.util.DefaultLogListener;
import org.geysermc.pack.converter.util.LogListener;
import org.geysermc.pack.converter.util.VanillaPackProvider;

public class TranslationManager
implements EventRegistrar {
    private static final PackGenerator packGenerator = new PackGenerator();
    private boolean generatedResources = false;
    public static boolean INCLUDE_OPTIONAL_TEXTURES_HACK = false;
    public static boolean INCLUDE_TEXTURE_HACK = false;

    public void registerHooks() {
        Path packSourceDir;
        List<ItemTranslator> translators = List.of(new BlockTranslator(), new ItemTranslator());
        try {
            packSourceDir = Files.createTempDirectory("bedframe", new FileAttribute[0]);
        }
        catch (IOException e) {
            BedframeConstants.LOGGER.error("Couldn't create resource pack temporary directory", (Throwable)e);
            return;
        }
        Path resourcePack = BedframeConstants.CONFIG_DIR.resolve("bedframe.zip");
        Path vanillaPath = BedframeConstants.CONFIG_DIR.resolve("vanilla.zip");
        INCLUDE_TEXTURE_HACK = true;
        VanillaPackProvider.create((Path)vanillaPath, (LogListener)new DefaultLogListener());
        INCLUDE_TEXTURE_HACK = false;
        try {
            ResourceHelper.VANILLA_PACK = new ZipFile(vanillaPath.toFile());
        }
        catch (IOException e) {
            BedframeConstants.LOGGER.error("Couldn't read vanilla resources", (Throwable)e);
        }
        EventBus eventBus = GeyserApi.api().eventBus();
        for (Translator translator : translators) {
            translator.register((EventBus<EventRegistrar>)eventBus, packSourceDir);
        }
        eventBus.subscribe((Object)this, GeyserDefineResourcePacksEvent.class, event -> {
            try {
                if (!translators.stream().allMatch(Translator::hasProvidedResources)) {
                    return;
                }
                if (!this.generatedResources) {
                    Files.deleteIfExists(resourcePack);
                    packGenerator.generatePack(packSourceDir, resourcePack.toFile(), translators);
                    this.generatedResources = true;
                }
                event.register(ResourcePack.create((PackCodec)PackCodec.path((Path)resourcePack)), new ResourcePackOption[0]);
                BedframeConstants.LOGGER.info("Registered resource pack");
            }
            catch (IOException e) {
                BedframeConstants.LOGGER.error("Couldn't generate resource pack", (Throwable)e);
            }
        });
    }
}

