/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.bedframe.geyser.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lol.sylvie.bedframe.util.BedframeConstants;
import net.minecraft.class_3545;
import org.geysermc.pack.bedrock.resource.models.entity.ModelEntity;
import org.geysermc.pack.bedrock.resource.models.entity.modelentity.Geometry;
import org.geysermc.pack.bedrock.resource.models.entity.modelentity.geometry.Bones;
import org.geysermc.pack.bedrock.resource.models.entity.modelentity.geometry.Description;
import org.geysermc.pack.bedrock.resource.models.entity.modelentity.geometry.bones.Cubes;
import org.geysermc.pack.bedrock.resource.models.entity.modelentity.geometry.bones.cubes.Uv;
import org.geysermc.pack.bedrock.resource.models.entity.modelentity.geometry.bones.cubes.uv.Down;
import org.geysermc.pack.bedrock.resource.models.entity.modelentity.geometry.bones.cubes.uv.East;
import org.geysermc.pack.bedrock.resource.models.entity.modelentity.geometry.bones.cubes.uv.North;
import org.geysermc.pack.bedrock.resource.models.entity.modelentity.geometry.bones.cubes.uv.South;
import org.geysermc.pack.bedrock.resource.models.entity.modelentity.geometry.bones.cubes.uv.Up;
import org.geysermc.pack.bedrock.resource.models.entity.modelentity.geometry.bones.cubes.uv.West;
import team.unnamed.creative.base.Axis3D;
import team.unnamed.creative.base.CubeFace;
import team.unnamed.creative.base.Vector2Float;
import team.unnamed.creative.model.Element;
import team.unnamed.creative.model.ElementFace;
import team.unnamed.creative.model.ElementRotation;
import team.unnamed.creative.model.Model;
import team.unnamed.creative.texture.TextureUV;

public class JavaGeometryConverter {
    private static final String FORMAT_VERSION = "1.16.0";
    private static final String GEOMETRY_FORMAT = "geometry.%s";

    private static float[] javaPosToBedrock(float[] java) {
        return new float[]{java[0] - 8.0f, java[1], java[2] - 8.0f};
    }

    private static void applyFaceUv(Uv uv, CubeFace cubeFace, float[] uvValue, float[] uvSize, String texture) {
        switch (cubeFace) {
            case UP: {
                Up up = new Up();
                up.uv(uvValue);
                up.uvSize(uvSize);
                up.materialInstance(texture);
                uv.up(up);
                break;
            }
            case DOWN: {
                Down down = new Down();
                down.uv(uvValue);
                down.uvSize(uvSize);
                down.materialInstance(texture);
                uv.down(down);
                break;
            }
            case NORTH: {
                North north = new North();
                north.uv(uvValue);
                north.uvSize(uvSize);
                north.materialInstance(texture);
                uv.north(north);
                break;
            }
            case SOUTH: {
                South south = new South();
                south.uv(uvValue);
                south.uvSize(uvSize);
                south.materialInstance(texture);
                uv.south(south);
                break;
            }
            case EAST: {
                East east = new East();
                east.uv(uvValue);
                east.uvSize(uvSize);
                east.materialInstance(texture);
                uv.east(east);
                break;
            }
            case WEST: {
                West west = new West();
                west.uv(uvValue);
                west.uvSize(uvSize);
                west.materialInstance(texture);
                uv.west(west);
            }
        }
    }

    public static class_3545<String, ModelEntity> convert(Model model) {
        List elements = model.elements();
        if (elements.isEmpty()) {
            BedframeConstants.LOGGER.error("Model {} is empty :(", (Object)model.key());
            return null;
        }
        ModelEntity modelEntity = new ModelEntity();
        modelEntity.formatVersion(FORMAT_VERSION);
        Geometry geometry = new Geometry();
        ArrayList<Bones> bones = new ArrayList<Bones>();
        int nthElement = 0;
        for (Element element : elements) {
            float[] javaFrom = element.from().toArray();
            float[] javaTo = element.to().toArray();
            Bones bone = new Bones();
            bone.name("element_" + nthElement);
            Cubes cube = new Cubes();
            cube.origin(JavaGeometryConverter.javaPosToBedrock(javaFrom));
            cube.size(new float[]{javaTo[0] - javaFrom[0], javaTo[1] - javaFrom[1], javaTo[2] - javaFrom[2]});
            cube.inflate(0.0f);
            ElementRotation rotation = element.rotation();
            if (rotation != null) {
                float[] rotOrigin = rotation.origin().toArray();
                bone.pivot(JavaGeometryConverter.javaPosToBedrock(rotOrigin));
                float rotValue = (360.0f - rotation.angle()) % 360.0f;
                Axis3D axis = rotation.axis();
                float[] fArray = new float[]{axis == Axis3D.X ? rotValue : 0.0f, axis == Axis3D.Y ? rotValue : 0.0f, axis == Axis3D.Z ? rotValue : 0.0f};
                bone.rotation(fArray);
            } else {
                bone.pivot(new float[]{0.0f, 0.0f, 0.0f});
            }
            Uv uv = new Uv();
            HashMap<CubeFace, ElementFace> faceMap = element.faces();
            if (faceMap.isEmpty()) {
                faceMap = new HashMap<CubeFace, ElementFace>();
                for (CubeFace face : CubeFace.values()) {
                    faceMap.put(face, ElementFace.face().texture(face.name()).build());
                }
            }
            for (Map.Entry entry : faceMap.entrySet()) {
                float[] uvSize;
                float[] uvValue;
                CubeFace face;
                CubeFace direction = (CubeFace)entry.getKey();
                face = (ElementFace)entry.getValue();
                TextureUV textureUV = face.uv0();
                textureUV = textureUV == null ? TextureUV.uv((float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f) : TextureUV.uv((Vector2Float)textureUV.from().multiply(16.0f), (Vector2Float)textureUV.to().multiply(16.0f));
                if (direction.axis() == Axis3D.Y) {
                    uvValue = new float[]{textureUV.to().x(), textureUV.to().y()};
                    uvSize = new float[]{textureUV.from().x() - uvValue[0], textureUV.from().y() - uvValue[1]};
                } else {
                    uvValue = new float[]{textureUV.from().x(), textureUV.from().y()};
                    uvSize = new float[]{textureUV.to().x() - uvValue[0], textureUV.to().y() - uvValue[1]};
                }
                JavaGeometryConverter.applyFaceUv(uv, direction, uvValue, uvSize, face.texture().replace("#", ""));
            }
            cube.uv(uv);
            bone.cubes(List.of(cube));
            bone.textureMeshes(null);
            bones.add(bone);
            ++nthElement;
        }
        geometry.bones(bones);
        modelEntity.geometry(List.of(geometry));
        String namespace = model.key().namespace();
        String[] pathSplit = model.key().value().split("/");
        String path = pathSplit[pathSplit.length - 1];
        String geometryName = String.format(GEOMETRY_FORMAT, (String)(namespace.equals("minecraft") ? "" : namespace + ".") + path.replace(":", "."));
        Description description = new Description();
        description.identifier(geometryName);
        description.textureWidth(16.0f);
        description.textureHeight(16.0f);
        geometry.description(description);
        return new class_3545((Object)geometryName, (Object)modelEntity);
    }
}

