/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.bedframe.geyser.translator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import eu.pb4.polymer.blocks.api.BlockResourceCreator;
import eu.pb4.polymer.blocks.api.MultiPolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import lol.sylvie.bedframe.geyser.TranslationManager;
import lol.sylvie.bedframe.geyser.Translator;
import lol.sylvie.bedframe.geyser.model.JavaGeometryConverter;
import lol.sylvie.bedframe.mixin.BlockResourceCreatorAccessor;
import lol.sylvie.bedframe.mixin.PolymerBlockResourceUtilsAccessor;
import lol.sylvie.bedframe.util.BedframeConstants;
import lol.sylvie.bedframe.util.PathHelper;
import lol.sylvie.bedframe.util.ResourceHelper;
import net.kyori.adventure.key.Key;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3619;
import net.minecraft.class_7923;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockPermutation;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.NonVanillaCustomBlockData;
import org.geysermc.geyser.api.block.custom.component.BoxComponent;
import org.geysermc.geyser.api.block.custom.component.CustomBlockComponents;
import org.geysermc.geyser.api.block.custom.component.GeometryComponent;
import org.geysermc.geyser.api.block.custom.component.MaterialInstance;
import org.geysermc.geyser.api.block.custom.component.TransformationComponent;
import org.geysermc.geyser.api.block.custom.nonvanilla.JavaBlockState;
import org.geysermc.geyser.api.block.custom.nonvanilla.JavaBoundingBox;
import org.geysermc.geyser.api.event.EventBus;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCustomBlocksEvent;
import org.geysermc.geyser.api.util.CreativeCategory;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.geyser.util.SoundUtils;
import org.geysermc.pack.bedrock.resource.models.entity.ModelEntity;
import org.geysermc.pack.converter.type.model.ModelStitcher;
import team.unnamed.creative.model.Model;
import team.unnamed.creative.model.ModelTexture;
import team.unnamed.creative.model.ModelTextures;
import team.unnamed.creative.serialize.minecraft.model.ModelSerializer;
import xyz.nucleoid.packettweaker.PacketContext;

public class BlockTranslator
extends Translator {
    private static final Map<String, List<class_3545<String, String>>> parentFaceMap = Map.of("block/cube_all", List.of(new class_3545((Object)"all", (Object)"*")), "block/cross", List.of(new class_3545((Object)"particle", (Object)"*"), new class_3545((Object)"cross", (Object)"*")), "block/cube_bottom_top", List.of(new class_3545((Object)"side", (Object)"*"), new class_3545((Object)"top", (Object)"up"), new class_3545((Object)"bottom", (Object)"down"), new class_3545((Object)"side", (Object)"north"), new class_3545((Object)"side", (Object)"south"), new class_3545((Object)"side", (Object)"east"), new class_3545((Object)"side", (Object)"west")), "block/cube_column", List.of(new class_3545((Object)"side", (Object)"*"), new class_3545((Object)"end", (Object)"up"), new class_3545((Object)"end", (Object)"down"), new class_3545((Object)"side", (Object)"north"), new class_3545((Object)"side", (Object)"south"), new class_3545((Object)"side", (Object)"east"), new class_3545((Object)"side", (Object)"west")), "block/cube_column_horizontal", List.of(new class_3545((Object)"side", (Object)"*"), new class_3545((Object)"end", (Object)"up"), new class_3545((Object)"end", (Object)"down"), new class_3545((Object)"side", (Object)"north"), new class_3545((Object)"side", (Object)"south"), new class_3545((Object)"side", (Object)"east"), new class_3545((Object)"side", (Object)"west")), "block/orientable", List.of(new class_3545((Object)"side", (Object)"*"), new class_3545((Object)"front", (Object)"north"), new class_3545((Object)"top", (Object)"up"), new class_3545((Object)"bottom", (Object)"down")));
    private static final ArrayList<PolymerBlock> registeredBlocks = new ArrayList();
    private final HashMap<class_2960, PolymerTexturedBlock> blocks = new HashMap();

    public BlockTranslator() {
        Stream blockIds = class_7923.field_41175.method_10235().stream();
        blockIds.forEach(identifier -> {
            class_2248 block = (class_2248)class_7923.field_41175.method_63535(identifier);
            if (block instanceof PolymerTexturedBlock) {
                PolymerTexturedBlock texturedBlock = (PolymerTexturedBlock)block;
                this.blocks.put((class_2960)identifier, texturedBlock);
            }
        });
    }

    private void forEachBlock(BiConsumer<class_2960, PolymerTexturedBlock> function) {
        for (Map.Entry<class_2960, PolymerTexturedBlock> entry : this.blocks.entrySet()) {
            try {
                function.accept(entry.getKey(), entry.getValue());
            }
            catch (RuntimeException e) {
                BedframeConstants.LOGGER.error("Couldn't load block {}", (Object)entry.getKey(), (Object)e);
            }
        }
    }

    private void populateProperties(CustomBlockData.Builder builder, Collection<class_2769<?>> properties) {
        block5: for (class_2769<?> property : properties) {
            class_2769<?> class_27692;
            Objects.requireNonNull(property);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2758.class, class_2746.class, class_2754.class}, class_27692, n)) {
                case 0: {
                    class_2758 intProperty = (class_2758)class_27692;
                    builder.intProperty(property.method_11899(), List.copyOf(intProperty.method_11898()));
                    continue block5;
                }
                case 1: {
                    class_2746 ignored = (class_2746)class_27692;
                    builder.booleanProperty(property.method_11899());
                    continue block5;
                }
                case 2: {
                    class_2754 enumProperty = (class_2754)class_27692;
                    builder.stringProperty(enumProperty.method_11899(), enumProperty.method_11898().stream().map(rec$ -> ((Enum)rec$).name()).map(String::toLowerCase).toList());
                    continue block5;
                }
            }
            BedframeConstants.LOGGER.error("Unknown property type: {}", (Object)property.getClass().getName());
        }
    }

    private BoxComponent voxelShapeToBoxComponent(class_265 shape) {
        if (shape.method_1110()) {
            return BoxComponent.emptyBox();
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        float maxZ = -3.4028235E38f;
        for (class_238 boundingBox : shape.method_1090()) {
            double offsetX = boundingBox.method_17939() * 0.5;
            double offsetY = boundingBox.method_17940() * 0.5;
            double offsetZ = boundingBox.method_17941() * 0.5;
            class_243 center = boundingBox.method_1005();
            minX = Math.min(minX, (float)(center.method_10216() - offsetX));
            minY = Math.min(minY, (float)(center.method_10214() - offsetY));
            minZ = Math.min(minZ, (float)(center.method_10215() - offsetZ));
            maxX = Math.max(maxX, (float)(center.method_10216() + offsetX));
            maxY = Math.max(maxY, (float)(center.method_10214() + offsetY));
            maxZ = Math.max(maxZ, (float)(center.method_10215() + offsetZ));
        }
        minX = MathUtils.clamp((float)minX, (float)0.0f, (float)1.0f);
        minY = MathUtils.clamp((float)minY, (float)0.0f, (float)1.0f);
        minZ = MathUtils.clamp((float)minZ, (float)0.0f, (float)1.0f);
        maxX = MathUtils.clamp((float)maxX, (float)0.0f, (float)1.0f);
        maxY = MathUtils.clamp((float)maxY, (float)0.0f, (float)1.0f);
        maxZ = MathUtils.clamp((float)maxZ, (float)0.0f, (float)1.0f);
        return new BoxComponent(16.0f * (1.0f - maxX) - 8.0f, 16.0f * minY, 16.0f * minZ - 8.0f, 16.0f * (maxX - minX), 16.0f * (maxY - minY), 16.0f * (maxZ - minZ));
    }

    private Model resolveModel(class_2960 identifier) {
        try {
            Object modelPath = identifier.method_12832();
            if (!((String)modelPath).startsWith("item/") && !((String)modelPath).startsWith("block/")) {
                modelPath = "block/" + (String)modelPath;
            }
            JsonObject model = ResourceHelper.readJsonResource(identifier.method_12836(), "models/" + (String)modelPath + ".json");
            return ModelSerializer.INSTANCE.deserializeFromJson((JsonElement)model, Key.key((String)identifier.toString()));
        }
        catch (RuntimeException e) {
            BedframeConstants.LOGGER.warn("Couldn't resolve model {}", (Object)identifier);
            return null;
        }
    }

    public static boolean isRegisteredBlock(PolymerBlock block) {
        return registeredBlocks.contains(block);
    }

    public void handle(GeyserDefineCustomBlocksEvent event, Path packRoot) {
        Path textureDir = PathHelper.createDirectoryOrThrow(packRoot.resolve("textures"));
        PathHelper.createDirectoryOrThrow(textureDir.resolve("blocks"));
        Path modelsDir = PathHelper.createDirectoryOrThrow(packRoot.resolve("models"));
        Path blockModelsDir = PathHelper.createDirectoryOrThrow(modelsDir.resolve("blocks"));
        JsonObject terrainTextureObject = new JsonObject();
        terrainTextureObject.addProperty("resource_pack_name", "Bedframe");
        terrainTextureObject.addProperty("texture_name", "atlas.terrain");
        JsonObject blocksJson = new JsonObject();
        blocksJson.addProperty("format_version", "1.21.40");
        JsonObject soundsJson = new JsonObject();
        JsonObject blockSoundsObject = new JsonObject();
        JsonObject interactiveSoundsObject = new JsonObject();
        JsonObject interactiveSoundsWrapper = new JsonObject();
        JsonObject textureDataObject = new JsonObject();
        this.forEachBlock((identifier, block) -> {
            class_2248 realBlock = (class_2248)class_7923.field_41175.method_63535(identifier);
            this.addTranslationKey("block." + identifier.method_12836() + "." + identifier.method_12832(), realBlock.method_63499());
            NonVanillaCustomBlockData.Builder builder = NonVanillaCustomBlockData.builder().name(identifier.method_12832()).namespace(identifier.method_12836()).creativeGroup("itemGroup." + identifier.method_12836() + ".blocks").creativeCategory(CreativeCategory.CONSTRUCTION).includedInCreativeInventory(true);
            this.populateProperties((CustomBlockData.Builder)builder, realBlock.method_9595().method_11659());
            ArrayList<CustomBlockPermutation> permutations = new ArrayList<CustomBlockPermutation>();
            for (class_2680 state : realBlock.method_9595().method_11662()) {
                CustomBlockComponents.Builder stateComponentBuilder = CustomBlockComponents.builder();
                float hardness = state.method_26214((class_1922)class_2682.field_12294, class_2338.field_10980);
                stateComponentBuilder.destructibleByMining(Float.valueOf(hardness));
                TranslationManager.INCLUDE_OPTIONAL_TEXTURES_HACK = true;
                class_2680 polymerBlockState = block.getPolymerBlockState(state, PacketContext.get());
                BlockResourceCreator creator = PolymerBlockResourceUtilsAccessor.getCREATOR();
                Either<PolymerBlockModel[], MultiPolymerBlockModel> polymerBlockModels = ((BlockResourceCreatorAccessor)creator).getModels().get(polymerBlockState);
                TranslationManager.INCLUDE_OPTIONAL_TEXTURES_HACK = false;
                if (polymerBlockModels == null) {
                    BedframeConstants.LOGGER.warn("Models are null for blockstate {}", (Object)state);
                    continue;
                }
                PolymerBlockModel[] listModels = polymerBlockModels.left().isPresent() ? (PolymerBlockModel[])polymerBlockModels.left().orElseThrow() : (PolymerBlockModel[])((MultiPolymerBlockModel)polymerBlockModels.right().orElseThrow()).models().getFirst();
                if (listModels.length == 0) {
                    BedframeConstants.LOGGER.warn("Models are empty for blockstate {}", (Object)state);
                    continue;
                }
                PolymerBlockModel modelEntry = listModels[0];
                TransformationComponent rotationComponent = new TransformationComponent((360 - modelEntry.x()) % 360, (360 - modelEntry.y()) % 360, 0);
                stateComponentBuilder.transformation(rotationComponent);
                String renderMethod = state.method_26225() ? "opaque" : "blend";
                class_2960 blockModelId = modelEntry.model();
                Model blockModel = this.resolveModel(blockModelId);
                if (blockModel == null) {
                    BedframeConstants.LOGGER.warn("Couldn't load model for blockstate {}", (Object)state);
                    continue;
                }
                HashMap<String, ModelTexture> materials = new HashMap<String, ModelTexture>();
                Key modelParentKey = blockModel.parent();
                if (modelParentKey != null && parentFaceMap.containsKey(modelParentKey.value())) {
                    String geometryIdentifier;
                    boolean cross = modelParentKey.toString().equals("minecraft:block/cross");
                    String string = geometryIdentifier = cross ? "minecraft:geometry.cross" : "minecraft:geometry.full_block";
                    if (cross) {
                        renderMethod = "alpha_test_single_sided";
                    }
                    GeometryComponent geometryComponent = GeometryComponent.builder().identifier(geometryIdentifier).build();
                    stateComponentBuilder.geometry(geometryComponent);
                    ModelTextures textures = blockModel.textures();
                    Map map = textures.variables();
                    List<class_3545<String, String>> faceMap = parentFaceMap.get(modelParentKey.value());
                    for (class_3545<String, String> face : faceMap) {
                        String javaFaceName = (String)face.method_15442();
                        String bedrockFaceName = (String)face.method_15441();
                        if (!map.containsKey(javaFaceName)) continue;
                        materials.put(bedrockFaceName, (ModelTexture)map.get(javaFaceName));
                    }
                } else {
                    ModelStitcher.Provider provider = key -> this.resolveModel(class_2960.method_60654((String)key.asString()));
                    class_3545<String, ModelEntity> nameAndModel = JavaGeometryConverter.convert(blockModel = new ModelStitcher(provider, blockModel).stitch());
                    if (nameAndModel == null) {
                        BedframeConstants.LOGGER.error("Couldn't convert model for blockstate {}", (Object)state);
                        continue;
                    }
                    String string = (String)nameAndModel.method_15442();
                    BlockTranslator.writeJsonToFile(nameAndModel.method_15441(), blockModelsDir.resolve(string + ".geo.json").toFile());
                    for (Map.Entry entry : blockModel.textures().variables().entrySet()) {
                        String key2 = (String)entry.getKey();
                        ModelTexture texture = (ModelTexture)entry.getValue();
                        materials.put(key2, texture);
                    }
                    GeometryComponent geometryComponent = GeometryComponent.builder().identifier(string).build();
                    stateComponentBuilder.geometry(geometryComponent);
                }
                if (materials.isEmpty()) {
                    BedframeConstants.LOGGER.error("Couldn't generate materials for blockstate {}", (Object)state);
                    continue;
                }
                ModelTextures textures = blockModel.textures();
                if (!materials.containsKey("*")) {
                    ModelTexture texture = textures.particle() == null ? (ModelTexture)materials.values().iterator().next() : textures.particle();
                    materials.put("*", texture);
                }
                for (Map.Entry entry : materials.entrySet()) {
                    String string;
                    ModelTexture texture = (ModelTexture)entry.getValue();
                    while (texture.key() == null && (string = texture.reference()) != null && materials.containsKey(string)) {
                        texture = (ModelTexture)materials.get(string);
                    }
                    if (texture.key() == null) {
                        BedframeConstants.LOGGER.warn("Texture for block {} on side {} is missing", identifier, entry.getKey());
                        continue;
                    }
                    String string2 = texture.key().asString();
                    if (!textureDataObject.has(string2)) {
                        class_2960 textureIdentifier = class_2960.method_60654((String)string2);
                        String texturePath = "textures/" + textureIdentifier.method_12832();
                        String bedrockPath = ResourceHelper.javaToBedrockTexture(texturePath);
                        JsonObject thisTexture = new JsonObject();
                        thisTexture.addProperty("textures", bedrockPath);
                        textureDataObject.add(string2, (JsonElement)thisTexture);
                        ResourceHelper.copyResource(textureIdentifier.method_12836(), texturePath + ".png", packRoot.resolve(bedrockPath + ".png"));
                    }
                    stateComponentBuilder.materialInstance((String)entry.getKey(), MaterialInstance.builder().renderMethod(renderMethod).texture(string2).faceDimming(true).ambientOcclusion(blockModel.ambientOcclusion()).build());
                }
                class_265 collisionBox = state.method_26220((class_1922)class_2682.field_12294, class_2338.field_10980);
                stateComponentBuilder.collisionBox(this.voxelShapeToBoxComponent(collisionBox));
                class_265 class_2652 = state.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980);
                stateComponentBuilder.selectionBox(this.voxelShapeToBoxComponent(class_2652));
                stateComponentBuilder.lightEmission(Integer.valueOf(state.method_26213()));
                CustomBlockComponents stateComponents = stateComponentBuilder.build();
                if (state.method_28501().isEmpty()) {
                    builder.components(stateComponents);
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (class_2769 property : state.method_28501()) {
                    Object propertyValue = state.method_11654(property).toString();
                    if (property instanceof class_2754) {
                        propertyValue = "'" + ((String)propertyValue).toLowerCase() + "'";
                    }
                    arrayList.add("q.block_property('%name%') == %value%".replace("%name%", property.method_11899()).replace("%value%", (CharSequence)propertyValue));
                }
                String stateCondition = String.join((CharSequence)" && ", arrayList);
                permutations.add(new CustomBlockPermutation(stateComponents, stateCondition));
            }
            builder.permutations(permutations);
            String blockAsString = identifier.toString();
            JsonObject thisBlockObject = new JsonObject();
            thisBlockObject.addProperty("sound", blockAsString);
            blocksJson.add(blockAsString, (JsonElement)thisBlockObject);
            class_2498 soundGroup = realBlock.method_9564().method_26231();
            JsonObject baseSoundObject = new JsonObject();
            baseSoundObject.addProperty("pitch", (Number)Float.valueOf(soundGroup.method_10599()));
            baseSoundObject.addProperty("volume", (Number)Float.valueOf(soundGroup.method_10597()));
            JsonObject soundEventsObject = new JsonObject();
            soundEventsObject.addProperty("break", SoundUtils.translatePlaySound((String)soundGroup.method_10595().comp_3319().toString()));
            soundEventsObject.addProperty("hit", SoundUtils.translatePlaySound((String)soundGroup.method_10596().comp_3319().toString()));
            soundEventsObject.addProperty("place", SoundUtils.translatePlaySound((String)soundGroup.method_10598().comp_3319().toString()));
            baseSoundObject.add("events", (JsonElement)soundEventsObject);
            blockSoundsObject.add(blockAsString, (JsonElement)baseSoundObject);
            JsonObject interactiveSoundObject = new JsonObject();
            interactiveSoundObject.addProperty("pitch", (Number)Float.valueOf(soundGroup.method_10599()));
            interactiveSoundObject.addProperty("volume", (Number)((double)soundGroup.method_10597() * 0.4));
            JsonObject interactiveEventsObject = new JsonObject();
            interactiveEventsObject.addProperty("fall", SoundUtils.translatePlaySound((String)soundGroup.method_10593().comp_3319().toString()));
            interactiveEventsObject.addProperty("jump", SoundUtils.translatePlaySound((String)soundGroup.method_10594().comp_3319().toString()));
            interactiveEventsObject.addProperty("step", SoundUtils.translatePlaySound((String)soundGroup.method_10594().comp_3319().toString()));
            interactiveEventsObject.addProperty("land", SoundUtils.translatePlaySound((String)soundGroup.method_10593().comp_3319().toString()));
            interactiveSoundObject.add("events", (JsonElement)interactiveEventsObject);
            interactiveSoundsObject.add(blockAsString, (JsonElement)interactiveSoundObject);
            NonVanillaCustomBlockData data = builder.build();
            event.register((CustomBlockData)data);
            registeredBlocks.add((PolymerBlock)block);
            for (class_2680 state : realBlock.method_9595().method_11662()) {
                CustomBlockState.Builder stateBuilder = data.blockStateBuilder();
                block12: for (class_2769 property : state.method_28501()) {
                    class_2769 selector0$temp;
                    Objects.requireNonNull(property);
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2758.class, class_2746.class, class_2754.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            class_2758 intProperty = (class_2758)selector0$temp;
                            stateBuilder.intProperty(property.method_11899(), ((Integer)state.method_11654((class_2769)intProperty)).intValue());
                            continue block12;
                        }
                        case 1: {
                            class_2746 booleanProperty = (class_2746)selector0$temp;
                            stateBuilder.booleanProperty(property.method_11899(), ((Boolean)state.method_11654((class_2769)booleanProperty)).booleanValue());
                            continue block12;
                        }
                        case 2: {
                            class_2754 class_27542 = (class_2754)selector0$temp;
                            stateBuilder.stringProperty(class_27542.method_11899(), ((Enum)((Object)state.method_11654((class_2769)class_27542))).toString().toLowerCase());
                            continue block12;
                        }
                    }
                    throw new IllegalArgumentException("Unknown property type: " + property.getClass().getName());
                }
                CustomBlockState customBlockState = stateBuilder.build();
                JavaBlockState.Builder javaBlockState = JavaBlockState.builder();
                javaBlockState.blockHardness(state.method_26214((class_1922)class_2682.field_12294, class_2338.field_10980));
                class_265 shape = state.method_26220((class_1922)class_2682.field_12294, class_2338.field_10980);
                if (shape.method_1110()) {
                    javaBlockState.collision(new JavaBoundingBox[0]);
                } else {
                    class_238 box = shape.method_1107();
                    javaBlockState.collision(new JavaBoundingBox[]{new JavaBoundingBox(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324)});
                }
                javaBlockState.javaId(class_2248.method_9507((class_2680)state));
                javaBlockState.identifier(class_2259.method_9685((class_2680)state));
                javaBlockState.waterlogged(((Boolean)state.method_61767((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false))).booleanValue());
                if (realBlock.method_8389() != null) {
                    javaBlockState.pickItem(class_7923.field_41178.method_10221((Object)realBlock.method_8389()).toString());
                }
                javaBlockState.canBreakWithHand(state.method_29291());
                class_3619 pistonBehavior = state.method_26223();
                javaBlockState.pistonBehavior(pistonBehavior == class_3619.field_15975 ? "NORMAL" : pistonBehavior.name());
                event.registerOverride(javaBlockState.build(), customBlockState);
            }
        });
        terrainTextureObject.add("texture_data", (JsonElement)textureDataObject);
        soundsJson.add("block_sounds", (JsonElement)blockSoundsObject);
        interactiveSoundsWrapper.add("block_sounds", (JsonElement)interactiveSoundsObject);
        soundsJson.add("interactive_sounds", (JsonElement)interactiveSoundsWrapper);
        BlockTranslator.writeJsonToFile(terrainTextureObject, textureDir.resolve("terrain_texture.json").toFile());
        BlockTranslator.writeJsonToFile(blocksJson, packRoot.resolve("blocks.json").toFile());
        BlockTranslator.writeJsonToFile(soundsJson, packRoot.resolve("sounds.json").toFile());
        this.markResourcesProvided();
    }

    @Override
    public void register(EventBus<EventRegistrar> eventBus, Path packRoot) {
        eventBus.subscribe((Object)this, GeyserDefineCustomBlocksEvent.class, event -> this.handle((GeyserDefineCustomBlocksEvent)event, packRoot));
    }
}

