/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.bedframe.geyser.translator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.pb4.polymer.core.api.item.PolymerItem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import lol.sylvie.bedframe.geyser.TranslationManager;
import lol.sylvie.bedframe.geyser.Translator;
import lol.sylvie.bedframe.util.BedframeConstants;
import lol.sylvie.bedframe.util.PathHelper;
import lol.sylvie.bedframe.util.ResourceHelper;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.geysermc.geyser.api.event.EventBus;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCustomItemsEvent;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.item.custom.NonVanillaCustomItemData;
import org.geysermc.geyser.api.util.CreativeCategory;
import xyz.nucleoid.packettweaker.PacketContext;

public class ItemTranslator
extends Translator {
    private final HashMap<class_2960, PolymerItem> items = new HashMap();
    private static final ArrayList<class_1792> registeredItems = new ArrayList();

    public ItemTranslator() {
        Stream itemIds = class_7923.field_41178.method_10235().stream();
        itemIds.forEach(identifier -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_63535(identifier);
            if (item instanceof PolymerItem) {
                PolymerItem polymerItem = (PolymerItem)item;
                this.items.put((class_2960)identifier, polymerItem);
            }
        });
    }

    private void forEachItem(BiConsumer<class_2960, PolymerItem> function) {
        for (Map.Entry<class_2960, PolymerItem> entry : this.items.entrySet()) {
            try {
                function.accept(entry.getKey(), entry.getValue());
            }
            catch (RuntimeException e) {
                BedframeConstants.LOGGER.error("Couldn't load item {}", (Object)entry.getKey(), (Object)e);
            }
        }
    }

    public static boolean isTexturedItem(class_1792 item) {
        return registeredItems.contains(item);
    }

    private void handle(GeyserDefineCustomItemsEvent event, Path packRoot) {
        Path textureDir = PathHelper.createDirectoryOrThrow(packRoot.resolve("textures"));
        PathHelper.createDirectoryOrThrow(textureDir.resolve("items"));
        JsonObject itemTextureObject = new JsonObject();
        itemTextureObject.addProperty("resource_pack_name", "bedframe");
        itemTextureObject.addProperty("texture_name", "atlas.items");
        JsonObject textureDataObject = new JsonObject();
        this.forEachItem((identifier, item) -> {
            class_1792 realItem = (class_1792)class_7923.field_41178.method_63535(identifier);
            class_1799 realDefaultItemStack = realItem.method_7854();
            TranslationManager.INCLUDE_OPTIONAL_TEXTURES_HACK = true;
            class_1799 itemStack = item.getPolymerItemStack(realItem.method_7854(), (class_1836)class_1836.field_41070, PacketContext.get());
            class_2960 model = (class_2960)itemStack.method_58694(class_9334.field_54199);
            TranslationManager.INCLUDE_OPTIONAL_TEXTURES_HACK = false;
            if (model == null || model.method_12836().equals("minecraft")) {
                return;
            }
            CustomItemOptions.Builder itemOptions = CustomItemOptions.builder();
            String translated = class_2561.method_43471((String)realItem.method_7876()).getString();
            NonVanillaCustomItemData.Builder itemBuilder = NonVanillaCustomItemData.builder().name(identifier.toString()).identifier(identifier.toString()).displayName(translated).creativeGroup("itemGroup." + identifier.method_12836() + ".items").creativeCategory(CreativeCategory.CONSTRUCTION.id()).allowOffhand(true);
            class_9323 components = realDefaultItemStack.method_57353();
            class_4174 foodComponent = (class_4174)components.method_58694(class_9334.field_50075);
            if (foodComponent != null) {
                itemBuilder.edible(true);
                itemBuilder.canAlwaysEat(foodComponent.comp_2493());
            }
            itemBuilder.foil(((Boolean)components.method_58695(class_9334.field_49641, (Object)false)).booleanValue());
            itemOptions.unbreakable(realDefaultItemStack.method_7963());
            itemBuilder.chargeable(realItem instanceof class_1764 || realItem instanceof class_1753);
            itemBuilder.customItemOptions(itemOptions.build());
            itemBuilder.javaId(class_7923.field_41178.method_56158((Object)realItem));
            if (realItem instanceof class_1747) {
                class_1747 blockItem = (class_1747)realItem;
                itemBuilder.icon("");
                itemBuilder.block(class_7923.field_41175.method_47983((Object)blockItem.method_7711()).method_55840());
            }
            String bedrockKey = "item." + String.valueOf(identifier) + ".name";
            this.addTranslationKey(bedrockKey, realItem.method_7876());
            try {
                JsonObject itemDescription = ResourceHelper.readJsonResource(model.method_12836(), "items/" + model.method_12832() + ".json");
                class_2960 modelId = class_2960.method_60654((String)itemDescription.get("model").getAsJsonObject().get("model").getAsString());
                JsonObject modelObject = ResourceHelper.readJsonResource(modelId.method_12836(), "models/" + modelId.method_12832() + ".json");
                class_2960 modelType = class_2960.method_60654((String)modelObject.get("parent").getAsString());
                boolean handheld = modelType.equals((Object)BedframeConstants.HANDHELD_IDENTIFIER);
                if (handheld) {
                    itemBuilder.displayHandheld(true);
                }
                if (modelType.equals((Object)BedframeConstants.GENERATED_IDENTIFIER) || handheld) {
                    class_2960 textureId = class_2960.method_60654((String)modelObject.get("textures").getAsJsonObject().get("layer0").getAsString());
                    String texturePath = "textures/" + textureId.method_12832();
                    String bedrockPath = ResourceHelper.javaToBedrockTexture(texturePath);
                    String textureName = identifier.toString();
                    JsonObject textureObject = new JsonObject();
                    textureObject.addProperty("textures", bedrockPath);
                    textureDataObject.add(textureName, (JsonElement)textureObject);
                    ResourceHelper.copyResource(textureId.method_12836(), texturePath + ".png", packRoot.resolve(bedrockPath + ".png"));
                    itemBuilder.icon(textureName);
                }
            }
            catch (NullPointerException e) {
                BedframeConstants.LOGGER.warn("Item {} has no model", identifier);
            }
            registeredItems.add(realItem);
            event.register(itemBuilder.build());
        });
        itemTextureObject.add("texture_data", (JsonElement)textureDataObject);
        ItemTranslator.writeJsonToFile(itemTextureObject, textureDir.resolve("item_texture.json").toFile());
        this.markResourcesProvided();
    }

    @Override
    public void register(EventBus<EventRegistrar> eventBus, Path packRoot) {
        eventBus.subscribe((Object)this, GeyserDefineCustomItemsEvent.class, event -> this.handle((GeyserDefineCustomItemsEvent)event, packRoot));
    }
}

