/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.bedframe.util;

import com.google.gson.JsonObject;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lol.sylvie.bedframe.util.BedframeConstants;
import net.minecraft.class_2960;

public class ResourceHelper {
    public static ResourcePackBuilder PACK_BUILDER = null;
    public static ZipFile VANILLA_PACK = null;

    public static InputStream getResource(String path) {
        byte[] data;
        if (PACK_BUILDER != null && (data = PACK_BUILDER.getData(path)) != null) {
            return new ByteArrayInputStream(data);
        }
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (stream != null) {
            return stream;
        }
        try {
            ZipEntry entry = VANILLA_PACK.getEntry(path);
            return VANILLA_PACK.getInputStream(entry);
        }
        catch (IOException e) {
            BedframeConstants.LOGGER.error("Couldn't find resource {}", (Object)path);
            throw new RuntimeException(e);
        }
    }

    public static String getResourcePath(String namespace, String path) {
        return "assets/" + namespace + "/" + path;
    }

    public static InputStream getResource(String namespace, String path) {
        return ResourceHelper.getResource(ResourceHelper.getResourcePath(namespace, path));
    }

    public static void copyResource(String namespace, String path, Path destination) {
        try {
            if (Files.notExists(destination, new LinkOption[0])) {
                destination.toFile().getParentFile().mkdirs();
                Files.copy(ResourceHelper.getResource(namespace, path), destination, new CopyOption[0]);
            }
        }
        catch (IOException | NullPointerException e) {
            throw new RuntimeException("Couldn't copy resource " + String.valueOf(class_2960.method_60655((String)namespace, (String)path)), e);
        }
    }

    public static JsonObject readJsonResource(String namespace, String path) {
        JsonObject jsonObject;
        block8: {
            InputStream stream = ResourceHelper.getResource(namespace, path);
            try {
                jsonObject = (JsonObject)BedframeConstants.GSON.fromJson((Reader)new InputStreamReader(stream), JsonObject.class);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't load resource " + String.valueOf(class_2960.method_60655((String)namespace, (String)path)), e);
                }
            }
            stream.close();
        }
        return jsonObject;
    }

    public static String javaToBedrockTexture(String javaPath) {
        return javaPath.replaceFirst("block", "blocks").replaceFirst("item", "items");
    }
}

