/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.bedframe.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lol.sylvie.bedframe.util.BedframeConstants;
import org.jetbrains.annotations.NotNull;

public class ZipHelper {
    public static void zipFolder(final Path source, File destination) {
        try {
            Path parent = Path.of(destination.getParent(), new String[0]);
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectory(parent, new FileAttribute[0]);
            }
            final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destination));
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                    zos.putNextEntry(new ZipEntry(source.relativize(file).toString()));
                    Files.copy(file, zos);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
            zos.close();
        }
        catch (IOException e) {
            BedframeConstants.LOGGER.error("Couldn't zip resource pack", (Throwable)e);
        }
    }
}

