/*
 * Decompiled with CFR 0.152.
 */
package com.spacewaltz.decrees;

import com.mojang.brigadier.CommandDispatcher;
import com.spacewaltz.decrees.DecreesConfig;
import com.spacewaltz.decrees.council.CouncilCommands;
import com.spacewaltz.decrees.council.CouncilConfig;
import com.spacewaltz.decrees.council.CouncilUtil;
import com.spacewaltz.decrees.council.SeatDefinition;
import com.spacewaltz.decrees.decree.Decree;
import com.spacewaltz.decrees.decree.DecreeStatus;
import com.spacewaltz.decrees.decree.DecreeStore;
import com.spacewaltz.decrees.decree.VotingRulesConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecreesOfTheSix
implements ModInitializer {
    public static final String MOD_ID = "decrees_of_the_six";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"decrees_of_the_six");

    public void onInitialize() {
        LOGGER.info("Initializing Decrees of the Six...");
        DecreesConfig.load();
        CouncilConfig.load();
        VotingRulesConfig.load();
        DecreeStore.load();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> CouncilCommands.register((CommandDispatcher<class_2168>)dispatcher));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            SeatDefinition seat = CouncilUtil.getSeatFor(player);
            if (seat == null) {
                return;
            }
            int pending = 0;
            for (Decree d : DecreeStore.get().decrees) {
                if (d.status != DecreeStatus.VOTING || d.votes.containsKey(seat.id)) continue;
                ++pending;
            }
            if (pending > 0) {
                String plural = pending == 1 ? "" : "s";
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[Decrees] \u00a7e" + seat.displayName + "\u00a76, you have \u00a7e" + pending + "\u00a76 decree" + plural + " awaiting your vote. Use \u00a7e/decrees decree list active\u00a76.")), false);
            }
        });
        LOGGER.info("Decrees of the Six initialized.");
    }
}

