/*
 * Decompiled with CFR 0.152.
 */
package com.spacewaltz.decrees.council;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.spacewaltz.decrees.council.CouncilConfig;
import com.spacewaltz.decrees.council.CouncilConfigData;
import com.spacewaltz.decrees.council.CouncilUtil;
import com.spacewaltz.decrees.council.SeatDefinition;
import com.spacewaltz.decrees.decree.Decree;
import com.spacewaltz.decrees.decree.DecreeData;
import com.spacewaltz.decrees.decree.DecreeHistoryLogger;
import com.spacewaltz.decrees.decree.DecreeStatus;
import com.spacewaltz.decrees.decree.DecreeStore;
import com.spacewaltz.decrees.decree.VoteChoice;
import com.spacewaltz.decrees.decree.VotingRulesConfig;
import com.spacewaltz.decrees.decree.VotingRulesData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;

public class CouncilCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder root = class_2170.method_9247((String)"decrees");
        LiteralArgumentBuilder helpCmd = (LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(ctx -> CouncilCommands.showHelp((class_2168)ctx.getSource()));
        LiteralArgumentBuilder reloadCmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(src -> src.method_9259(3))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            CouncilConfig.load();
            VotingRulesConfig.load();
            src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7a[Decrees] Reloaded council.json and voting_rules.json."));
            return 1;
        });
        LiteralArgumentBuilder seatCmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"seat").requires(src -> src.method_9259(3))).then(class_2170.method_9247((String)"list").executes(ctx -> CouncilCommands.listSeats((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"seat_id", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            String seatId = StringArgumentType.getString((CommandContext)ctx, (String)"seat_id");
            class_3222 player = class_2186.method_9315((CommandContext)ctx, (String)"player");
            return CouncilCommands.setSeat((class_2168)ctx.getSource(), seatId, player);
        }))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"seat_id", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String seatId = StringArgumentType.getString((CommandContext)ctx, (String)"seat_id");
            return CouncilCommands.clearSeat((class_2168)ctx.getSource(), seatId);
        })));
        LiteralArgumentBuilder editCmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"edit").then(class_2170.method_9247((String)"title").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(CouncilCommands::suggestDecreeIds).then(class_2170.method_9244((String)"new_title", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CouncilCommands.editTitle((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id"), StringArgumentType.getString((CommandContext)ctx, (String)"new_title"))))))).then(class_2170.method_9247((String)"description").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(CouncilCommands::suggestDecreeIds).then(class_2170.method_9244((String)"new_description", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CouncilCommands.editDescription((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id"), StringArgumentType.getString((CommandContext)ctx, (String)"new_description"))))))).then(class_2170.method_9247((String)"category").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(CouncilCommands::suggestDecreeIds).then(class_2170.method_9244((String)"new_category", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CouncilCommands.editCategory((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id"), StringArgumentType.getString((CommandContext)ctx, (String)"new_category"))))))).then(class_2170.method_9247((String)"expiry").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(CouncilCommands::suggestDecreeIds).then(class_2170.method_9247((String)"none").executes(ctx -> CouncilCommands.editExpiryClear((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id"))))).then(class_2170.method_9244((String)"days", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CouncilCommands.editExpirySet((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"days"))))));
        LiteralArgumentBuilder decreeCmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"decree").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(ctx -> CouncilCommands.listDecrees((class_2168)ctx.getSource()))).then(class_2170.method_9247((String)"my").executes(ctx -> CouncilCommands.listMyDecrees((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"active").executes(ctx -> CouncilCommands.listActiveDecrees((class_2168)ctx.getSource()))))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(CouncilCommands::suggestDecreeIds).executes(ctx -> CouncilCommands.decreeInfo((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id")))))).then(class_2170.method_9247((String)"results").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(CouncilCommands::suggestDecreeIds).executes(ctx -> CouncilCommands.decreeResults((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id")))))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"title", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CouncilCommands.createDecree((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"title")))))).then(class_2170.method_9247((String)"open").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(CouncilCommands::suggestDecreeIds).executes(ctx -> CouncilCommands.openDecree((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"force").requires(src -> src.method_9259(3))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(CouncilCommands::suggestDecreeIds).then(class_2170.method_9247((String)"enacted").executes(ctx -> CouncilCommands.forceDecreeStatus((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id"), DecreeStatus.ENACTED)))).then(class_2170.method_9247((String)"rejected").executes(ctx -> CouncilCommands.forceDecreeStatus((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id"), DecreeStatus.REJECTED)))))).then((ArgumentBuilder)editCmd)).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(CouncilCommands::suggestDecreeIds).executes(ctx -> CouncilCommands.deleteDecree((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id")))));
        LiteralArgumentBuilder voteCmd = (LiteralArgumentBuilder)class_2170.method_9247((String)"vote").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(CouncilCommands::suggestDecreeIds).then(class_2170.method_9247((String)"yes").executes(ctx -> CouncilCommands.vote((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id"), VoteChoice.YES)))).then(class_2170.method_9247((String)"no").executes(ctx -> CouncilCommands.vote((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id"), VoteChoice.NO)))).then(class_2170.method_9247((String)"abstain").executes(ctx -> CouncilCommands.vote((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id"), VoteChoice.ABSTAIN))));
        root.then((ArgumentBuilder)helpCmd);
        root.then((ArgumentBuilder)reloadCmd);
        root.then((ArgumentBuilder)seatCmd);
        root.then((ArgumentBuilder)decreeCmd);
        root.then((ArgumentBuilder)voteCmd);
        dispatcher.register(root);
    }

    private static int showHelp(class_2168 src) {
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a76[Decrees] Command overview:"));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees help \u00a77- Show this help."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees reload \u00a77- Reload council & voting configs (ops only)."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees seat list \u00a77- List all council seats (ops only)."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees seat set <seat_id> <player> \u00a77- Assign a player to a seat (ops only)."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees seat clear <seat_id> \u00a77- Clear the holder of a seat (ops only)."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees decree create <title> \u00a77- Create a new decree (council only)."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees decree list \u00a77- List all decrees."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees decree list my \u00a77- List decrees created by your seat."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees decree list active \u00a77- Show decrees currently in VOTING."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees decree info <id> \u00a77- Show full info for a decree."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees decree results <id> \u00a77- Show detailed vote results."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees decree open <id> \u00a77- Open a decree for voting (council only)."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees decree force <id> enacted|rejected \u00a77- Force final status (ops only)."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees decree edit title|description|category|expiry ... \u00a77- Edit decree fields."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees decree delete <id> \u00a77- Delete a decree (council only)."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e/decrees vote <id> yes|no|abstain \u00a77- Cast your seat's vote."));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a78Note: Some commands require you to hold a council seat or be an operator."));
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestDecreeIds(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        List<String> ids = DecreeStore.get().decrees.stream().map(d -> Integer.toString(d.id)).toList();
        return class_2172.method_9265(ids, (SuggestionsBuilder)builder);
    }

    private static int listSeats(class_2168 src) {
        CouncilConfigData data = CouncilConfig.get();
        if (data.seats.isEmpty()) {
            src.method_45068((class_2561)class_2561.method_43470((String)"\u00a77[Decrees] No seats are defined in council.json."));
            return 1;
        }
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a76[Decrees] Council seats:"));
        for (SeatDefinition seat : data.seats) {
            Object holderStr = "\u00a78<empty>";
            if (seat.holderUuid != null) {
                Optional profileOpt;
                MinecraftServer server = src.method_9211();
                class_3312 userCache = server.method_3793();
                holderStr = userCache != null ? ((profileOpt = userCache.method_14512(seat.holderUuid)).isPresent() ? "\u00a7a" + ((GameProfile)profileOpt.get()).getName() : "\u00a7a" + seat.holderUuid.toString()) : "\u00a7a" + seat.holderUuid.toString();
            }
            src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a7e- " + seat.id + " \u00a77(" + seat.displayName + ")\u00a7r: " + (String)holderStr)));
        }
        return 1;
    }

    private static int setSeat(class_2168 src, String seatId, class_3222 player) {
        SeatDefinition seat = CouncilConfig.findSeat(seatId);
        if (seat == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] Unknown seat id: " + seatId)));
            return 0;
        }
        UUID playerUuid = player.method_5667();
        SeatDefinition existing = CouncilConfig.findSeatByHolder(playerUuid);
        if (existing != null && existing != seat) {
            existing.holderUuid = null;
        }
        seat.holderUuid = playerUuid;
        CouncilConfig.save();
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Seat \u00a7e" + seat.id + " \u00a77(" + seat.displayName + ")\u00a7a is now held by \u00a7b" + player.method_5477().getString() + "\u00a7a.")));
        return 1;
    }

    private static int clearSeat(class_2168 src, String seatId) {
        SeatDefinition seat = CouncilConfig.findSeat(seatId);
        if (seat == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] Unknown seat id: " + seatId)));
            return 0;
        }
        seat.holderUuid = null;
        CouncilConfig.save();
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Seat \u00a7e" + seat.id + " \u00a77(" + seat.displayName + ")\u00a7a has been cleared.")));
        return 1;
    }

    private static int listActiveDecrees(class_2168 src) {
        DecreeData data = DecreeStore.get();
        List<Decree> active = data.decrees.stream().filter(d -> d.status == DecreeStatus.VOTING).toList();
        if (active.isEmpty()) {
            src.method_45068((class_2561)class_2561.method_43470((String)"\u00a77[Decrees] There are no decrees currently in \u00a7eVOTING\u00a77."));
            return 1;
        }
        SeatDefinition callerSeat = null;
        class_1297 class_12972 = src.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            callerSeat = CouncilUtil.getSeatFor(player);
        }
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a76[Decrees] Active decrees in \u00a7eVOTING\u00a76:"));
        for (Decree d2 : active) {
            int yes = 0;
            int no = 0;
            int abstain = 0;
            for (VoteChoice v : d2.votes.values()) {
                if (v == VoteChoice.YES) {
                    ++yes;
                    continue;
                }
                if (v == VoteChoice.NO) {
                    ++no;
                    continue;
                }
                if (v != VoteChoice.ABSTAIN) continue;
                ++abstain;
            }
            String baseLine = " \u00a7e#" + d2.id + " \u00a77[" + String.valueOf((Object)d2.status) + "] \u00a7r" + d2.title + " \u00a78(Yes " + yes + ", No " + no + ", Abstain " + abstain + ")";
            if (callerSeat != null) {
                VoteChoice myVote = d2.votes.get(callerSeat.id);
                String myVoteText = myVote == null ? "\u00a7cPENDING" : (myVote == VoteChoice.YES ? "\u00a7aYES" : (myVote == VoteChoice.NO ? "\u00a7cNO" : "\u00a77ABSTAIN"));
                src.method_45068((class_2561)class_2561.method_43470((String)(baseLine + " \u00a77| Your vote: " + myVoteText)));
                continue;
            }
            src.method_45068((class_2561)class_2561.method_43470((String)baseLine));
        }
        return 1;
    }

    private static int listDecrees(class_2168 src) {
        DecreeData data = DecreeStore.get();
        if (data.decrees.isEmpty()) {
            src.method_45068((class_2561)class_2561.method_43470((String)"\u00a77[Decrees] There are currently no decrees."));
            return 1;
        }
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a76[Decrees] Decrees:"));
        for (Decree d : data.decrees) {
            src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a7e#" + d.id + " \u00a77[" + String.valueOf((Object)d.status) + "] \u00a7r" + d.title)));
        }
        return 1;
    }

    private static int listMyDecrees(class_2168 src) {
        class_1297 class_12972 = src.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Decrees] Only players can list their own decrees."));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        SeatDefinition seat = CouncilUtil.getSeatFor(player);
        if (seat == null) {
            src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Decrees] Only council members have personal decrees."));
            return 0;
        }
        DecreeData data = DecreeStore.get();
        boolean any = false;
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a76[Decrees] Decrees created by \u00a7e" + seat.displayName + "\u00a76:")));
        for (Decree d : data.decrees) {
            if (!seat.id.equals(d.createdBySeatId)) continue;
            any = true;
            src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a7e#" + d.id + " \u00a77[" + String.valueOf((Object)d.status) + "] \u00a7r" + d.title)));
        }
        if (!any) {
            src.method_45068((class_2561)class_2561.method_43470((String)"\u00a77[Decrees] Your seat has not created any decrees yet."));
        }
        return 1;
    }

    private static int decreeInfo(class_2168 src, int id) {
        Decree d = DecreeStore.find(id);
        if (d == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] No decree with id #" + id + ".")));
            return 0;
        }
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a76[Decrees] Decree #" + d.id)));
        src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Title: \u00a7r" + d.title)));
        String desc = d.description == null || d.description.isEmpty() ? "\u00a78<none>" : d.description;
        src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Description: \u00a7r" + desc)));
        String cat = d.category == null || d.category.isEmpty() ? "\u00a78<none>" : d.category;
        src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Category: \u00a7b" + cat)));
        if (d.expiresAt == null || d.expiresAt <= 0L) {
            src.method_45068((class_2561)class_2561.method_43470((String)" \u00a77Expiry: \u00a78none"));
        } else {
            long now = System.currentTimeMillis();
            long diff = d.expiresAt - now;
            if (diff <= 0L) {
                src.method_45068((class_2561)class_2561.method_43470((String)" \u00a77Expiry: \u00a7cEXPIRED (by time)"));
            } else {
                long days = diff / 86400000L;
                if (days < 1L) {
                    src.method_45068((class_2561)class_2561.method_43470((String)" \u00a77Expiry: \u00a7ein less than 1 day"));
                } else {
                    src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Expiry: \u00a7ein approx " + days + " day(s)")));
                }
            }
        }
        src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Status: \u00a7e" + String.valueOf((Object)d.status))));
        src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Created by seat: \u00a7b" + d.createdBySeatId)));
        if (d.votes.isEmpty()) {
            src.method_45068((class_2561)class_2561.method_43470((String)" \u00a77Votes: \u00a78none yet"));
        } else {
            src.method_45068((class_2561)class_2561.method_43470((String)" \u00a77Votes:"));
            d.votes.forEach((seatId, vote) -> src.method_45068((class_2561)class_2561.method_43470((String)("  \u00a7e- " + seatId + "\u00a77: \u00a7b" + String.valueOf(vote)))));
        }
        return 1;
    }

    private static int decreeResults(class_2168 src, int id) {
        int minVotesRequired;
        Decree d = DecreeStore.find(id);
        if (d == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] No decree with id #" + id + ".")));
            return 0;
        }
        int totalActiveSeats = (int)CouncilConfig.get().seats.stream().filter(s -> s.holderUuid != null).count();
        int yes = 0;
        int no = 0;
        int abstain = 0;
        for (VoteChoice v : d.votes.values()) {
            if (v == VoteChoice.YES) {
                ++yes;
                continue;
            }
            if (v == VoteChoice.NO) {
                ++no;
                continue;
            }
            if (v != VoteChoice.ABSTAIN) continue;
            ++abstain;
        }
        int votesCast = d.votes.size();
        VotingRulesData rules = VotingRulesConfig.get();
        if (rules == null) {
            rules = new VotingRulesData();
        }
        if (totalActiveSeats <= 0 || rules.minQuorumPercent <= 0) {
            minVotesRequired = 0;
        } else if (rules.minQuorumPercent >= 100) {
            minVotesRequired = totalActiveSeats;
        } else {
            double fraction = (double)rules.minQuorumPercent / 100.0;
            minVotesRequired = (int)Math.ceil((double)totalActiveSeats * fraction);
        }
        boolean hasQuorum = votesCast >= minVotesRequired;
        boolean timeExpired = false;
        long elapsedMinutes = 0L;
        if (rules.votingDurationMinutes > 0 && d.votingOpenedAt != null) {
            long now = System.currentTimeMillis();
            long diff = now - d.votingOpenedAt;
            elapsedMinutes = diff / 60000L;
            if (diff >= (long)rules.votingDurationMinutes * 60000L) {
                timeExpired = true;
            }
        }
        String mode = rules.majorityMode == null ? "SIMPLE" : rules.majorityMode.toUpperCase();
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a76[Decrees] Results for decree \u00a7e#" + d.id + "\u00a76: \u00a7r" + d.title)));
        src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Status: \u00a7e" + String.valueOf((Object)d.status))));
        src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Active seats: \u00a7e" + totalActiveSeats)));
        src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Votes: \u00a7aYes " + yes + "\u00a77, \u00a7cNo " + no + "\u00a77, \u00a78Abstain " + abstain + "\u00a77, Total " + votesCast)));
        if (minVotesRequired > 0) {
            src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Quorum: \u00a7e" + votesCast + "/" + minVotesRequired + (hasQuorum ? " \u00a7a(REACHED)" : " \u00a7c(NOT reached)"))));
        } else {
            src.method_45068((class_2561)class_2561.method_43470((String)" \u00a77Quorum: \u00a78none required"));
        }
        src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Majority mode: \u00a7e" + mode + "\u00a77, Ties: " + (rules.tiesPass ? "\u00a7apass" : "\u00a7cfail"))));
        if (rules.votingDurationMinutes > 0 && d.votingOpenedAt != null) {
            src.method_45068((class_2561)class_2561.method_43470((String)(" \u00a77Time: \u00a7e" + elapsedMinutes + "/" + rules.votingDurationMinutes + " min\u00a77 \u2192 " + (timeExpired ? "\u00a7cEXPIRED" : "\u00a7aONGOING"))));
        }
        if (!d.votes.isEmpty()) {
            src.method_45068((class_2561)class_2561.method_43470((String)" \u00a77Per seat:"));
            d.votes.forEach((seatId, vote) -> src.method_45068((class_2561)class_2561.method_43470((String)("  \u00a7e- " + seatId + "\u00a77: \u00a7b" + String.valueOf(vote)))));
        }
        return 1;
    }

    private static boolean checkGlobalFlags(class_2168 src) {
        CouncilConfigData cfg = CouncilConfig.get();
        if (cfg == null) {
            return true;
        }
        if (!cfg.decreesEnabled) {
            src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Decrees] The decree system is currently disabled in council.json."));
            return false;
        }
        if (cfg.opsOnly && !src.method_9259(3)) {
            src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Decrees] Decrees are currently restricted to server operators."));
            return false;
        }
        return true;
    }

    private static boolean ensureCouncil(class_2168 src, String action) {
        class_1297 class_12972 = src.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            src.method_9213((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] Only players can " + action + ".")));
            return false;
        }
        class_3222 player = (class_3222)class_12972;
        SeatDefinition seat = CouncilUtil.getSeatFor(player);
        if (seat == null) {
            src.method_9213((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] Only council members can " + action + ".")));
            return false;
        }
        return true;
    }

    private static void notifyCouncilVotingOpened(class_2168 src, Decree d) {
        class_3324 pm = src.method_9211().method_3760();
        for (class_3222 p : pm.method_14571()) {
            if (CouncilUtil.getSeatFor(p) == null) continue;
            p.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[Decrees] \u00a7e#" + d.id + "\u00a76 is now in \u00a7eVOTING\u00a76: \u00a7r" + d.title)), false);
        }
    }

    private static void notifyCouncilDecreeFinal(class_2168 src, Decree d) {
        class_3324 pm = src.method_9211().method_3760();
        for (class_3222 p : pm.method_14571()) {
            if (CouncilUtil.getSeatFor(p) == null) continue;
            if (d.status == DecreeStatus.ENACTED) {
                p.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Decree \u00a7e#" + d.id + "\u00a7a has been \u00a7lENACTED\u00a7r\u00a7a.")), false);
                continue;
            }
            if (d.status != DecreeStatus.REJECTED) continue;
            p.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] Decree \u00a7e#" + d.id + "\u00a7c has been \u00a7lREJECTED\u00a7r\u00a7c.")), false);
        }
    }

    private static int createDecree(class_2168 src, String title) {
        if (!CouncilCommands.checkGlobalFlags(src)) {
            return 0;
        }
        class_1297 class_12972 = src.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Decrees] Only players can create decrees."));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        SeatDefinition seat = CouncilUtil.getSeatFor(player);
        if (seat == null) {
            src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Decrees] Only council members can create decrees."));
            return 0;
        }
        Decree decree = DecreeStore.createDecree(title, seat.id);
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Created decree \u00a7e#" + decree.id + "\u00a7a with title: \u00a7r" + decree.title)));
        return 1;
    }

    private static int openDecree(class_2168 src, int id) {
        if (!CouncilCommands.checkGlobalFlags(src)) {
            return 0;
        }
        if (!CouncilCommands.ensureCouncil(src, "open decrees")) {
            return 0;
        }
        Decree d = DecreeStore.find(id);
        if (d == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] No decree with id #" + id + ".")));
            return 0;
        }
        if (d.status != DecreeStatus.DRAFT) {
            src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7c[Decrees] Only decrees in DRAFT status can be opened for voting."));
            return 0;
        }
        d.status = DecreeStatus.VOTING;
        d.votingOpenedAt = System.currentTimeMillis();
        DecreeStore.save();
        int totalActiveSeats = (int)CouncilConfig.get().seats.stream().filter(s -> s.holderUuid != null).count();
        VotingRulesData rules = VotingRulesConfig.get();
        if (rules == null) {
            rules = new VotingRulesData();
        }
        String durationText = rules.votingDurationMinutes <= 0 ? "no time limit" : rules.votingDurationMinutes + " min";
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Decree \u00a7e#" + d.id + "\u00a7a is now open for voting. (Active seats: \u00a7e" + totalActiveSeats + "\u00a7a)")));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77[Decrees] Rules: Majority \u00a7e" + rules.majorityMode + "\u00a77, Quorum \u00a7e" + rules.minQuorumPercent + "%\u00a77, Duration \u00a7e" + durationText + "\u00a77, Ties " + (rules.tiesPass ? "\u00a7apass" : "\u00a7cfail"))));
        src.method_9211().method_3760().method_43514((class_2561)class_2561.method_43470((String)("\u00a76[Decrees] Voting opened on decree \u00a7e#" + d.id + "\u00a76: " + d.title)), false);
        CouncilCommands.notifyCouncilVotingOpened(src, d);
        return 1;
    }

    private static int deleteDecree(class_2168 src, int id) {
        if (!CouncilCommands.checkGlobalFlags(src)) {
            return 0;
        }
        if (!CouncilCommands.ensureCouncil(src, "delete decrees")) {
            return 0;
        }
        DecreeData data = DecreeStore.get();
        boolean removed = data.decrees.removeIf(d -> d.id == id);
        if (!removed) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] No decree with id #" + id + ".")));
            return 0;
        }
        DecreeStore.save();
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Deleted decree \u00a7e#" + id + "\u00a7a.")));
        return 1;
    }

    private static int forceDecreeStatus(class_2168 src, int id, DecreeStatus newStatus) {
        if (!CouncilCommands.checkGlobalFlags(src)) {
            return 0;
        }
        if (!src.method_9259(3)) {
            src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Decrees] Only operators can force decree status."));
            return 0;
        }
        Decree d = DecreeStore.find(id);
        if (d == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] No decree with id #" + id + ".")));
            return 0;
        }
        DecreeStatus before = d.status;
        d.status = newStatus;
        DecreeStore.save();
        DecreeHistoryLogger.logStatusChange(d, newStatus, "FORCED_BY_OP:" + src.method_9214());
        src.method_9211().method_3760().method_43514((class_2561)class_2561.method_43470((String)("\u00a76[Decrees] Decree \u00a7e#" + d.id + "\u00a76 (" + d.title + ") was \u00a7eFORCED " + String.valueOf((Object)newStatus) + "\u00a76 by \u00a7e" + src.method_9214() + "\u00a76.")), false);
        if (newStatus == DecreeStatus.ENACTED || newStatus == DecreeStatus.REJECTED) {
            CouncilCommands.notifyCouncilDecreeFinal(src, d);
        }
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Forced decree \u00a7e#" + d.id + "\u00a7a from \u00a7e" + String.valueOf((Object)before) + "\u00a7a to \u00a7e" + String.valueOf((Object)newStatus) + "\u00a7a.")));
        return 1;
    }

    private static int editTitle(class_2168 src, int id, String newTitle) {
        if (!CouncilCommands.checkGlobalFlags(src)) {
            return 0;
        }
        if (!CouncilCommands.ensureCouncil(src, "edit decrees")) {
            return 0;
        }
        Decree d = DecreeStore.find(id);
        if (d == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] No decree with id #" + id + ".")));
            return 0;
        }
        d.title = newTitle;
        DecreeStore.save();
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Updated title of decree \u00a7e#" + id + "\u00a7a.")));
        return 1;
    }

    private static int editDescription(class_2168 src, int id, String newDescription) {
        if (!CouncilCommands.checkGlobalFlags(src)) {
            return 0;
        }
        if (!CouncilCommands.ensureCouncil(src, "edit decrees")) {
            return 0;
        }
        Decree d = DecreeStore.find(id);
        if (d == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] No decree with id #" + id + ".")));
            return 0;
        }
        d.description = newDescription;
        DecreeStore.save();
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Updated description of decree \u00a7e#" + id + "\u00a7a.")));
        return 1;
    }

    private static int editCategory(class_2168 src, int id, String newCategory) {
        if (!CouncilCommands.checkGlobalFlags(src)) {
            return 0;
        }
        if (!CouncilCommands.ensureCouncil(src, "edit decrees")) {
            return 0;
        }
        Decree d = DecreeStore.find(id);
        if (d == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] No decree with id #" + id + ".")));
            return 0;
        }
        d.category = newCategory;
        DecreeStore.save();
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Updated category of decree \u00a7e#" + id + "\u00a7a.")));
        return 1;
    }

    private static int editExpiryClear(class_2168 src, int id) {
        if (!CouncilCommands.checkGlobalFlags(src)) {
            return 0;
        }
        if (!CouncilCommands.ensureCouncil(src, "edit decrees")) {
            return 0;
        }
        Decree d = DecreeStore.find(id);
        if (d == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] No decree with id #" + id + ".")));
            return 0;
        }
        d.expiresAt = null;
        DecreeStore.save();
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Cleared expiry for decree \u00a7e#" + id + "\u00a7a.")));
        return 1;
    }

    private static int editExpirySet(class_2168 src, int id, int days) {
        if (!CouncilCommands.checkGlobalFlags(src)) {
            return 0;
        }
        if (!CouncilCommands.ensureCouncil(src, "edit decrees")) {
            return 0;
        }
        Decree d = DecreeStore.find(id);
        if (d == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] No decree with id #" + id + ".")));
            return 0;
        }
        long now = System.currentTimeMillis();
        long millis = (long)days * 86400000L;
        d.expiresAt = now + millis;
        DecreeStore.save();
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[Decrees] Set expiry of decree \u00a7e#" + id + "\u00a7a to about " + days + " day(s) from now.")));
        return 1;
    }

    private static int vote(class_2168 src, int id, VoteChoice choice) {
        int minVotesRequired;
        if (!CouncilCommands.checkGlobalFlags(src)) {
            return 0;
        }
        class_1297 class_12972 = src.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Decrees] Only players can vote."));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        SeatDefinition seat = CouncilUtil.getSeatFor(player);
        if (seat == null) {
            src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Decrees] Only council members can vote."));
            return 0;
        }
        Decree d = DecreeStore.find(id);
        if (d == null) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] No decree with id #" + id + ".")));
            return 0;
        }
        if (d.status != DecreeStatus.VOTING) {
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c[Decrees] Decree #" + id + " is not open for voting.")));
            return 0;
        }
        d.votes.put(seat.id, choice);
        int totalActiveSeats = (int)CouncilConfig.get().seats.stream().filter(s -> s.holderUuid != null).count();
        int yes = 0;
        int no = 0;
        int abstain = 0;
        for (VoteChoice c : d.votes.values()) {
            if (c == VoteChoice.YES) {
                ++yes;
                continue;
            }
            if (c == VoteChoice.NO) {
                ++no;
                continue;
            }
            if (c != VoteChoice.ABSTAIN) continue;
            ++abstain;
        }
        int votesCast = d.votes.size();
        VotingRulesData rules = VotingRulesConfig.get();
        if (rules == null) {
            rules = new VotingRulesData();
        }
        if (totalActiveSeats <= 0 || rules.minQuorumPercent <= 0) {
            minVotesRequired = 0;
        } else if (rules.minQuorumPercent >= 100) {
            minVotesRequired = totalActiveSeats;
        } else {
            double fraction = (double)rules.minQuorumPercent / 100.0;
            minVotesRequired = (int)Math.ceil((double)totalActiveSeats * fraction);
        }
        boolean hasQuorum = votesCast >= minVotesRequired;
        boolean timeExpired = false;
        if (rules.votingDurationMinutes > 0 && d.votingOpenedAt != null) {
            long limitMillis = (long)rules.votingDurationMinutes * 60000L;
            long now = System.currentTimeMillis();
            if (now - d.votingOpenedAt >= limitMillis) {
                timeExpired = true;
            }
        }
        boolean allVoted = totalActiveSeats > 0 && votesCast == totalActiveSeats;
        DecreeStatus before = d.status;
        if (hasQuorum && (allVoted || timeExpired)) {
            int requiredYes = "TWO_THIRDS".equalsIgnoreCase(rules.majorityMode) ? (int)Math.ceil((double)votesCast * 2.0 / 3.0) : votesCast / 2 + 1;
            d.status = votesCast == 0 ? DecreeStatus.REJECTED : (yes > no && yes >= requiredYes ? DecreeStatus.ENACTED : (yes == no ? (rules.tiesPass ? DecreeStatus.ENACTED : DecreeStatus.REJECTED) : DecreeStatus.REJECTED));
        } else if (timeExpired && !hasQuorum) {
            d.status = DecreeStatus.REJECTED;
        }
        DecreeStatus after = d.status;
        DecreeStore.save();
        if (before != after && (after == DecreeStatus.ENACTED || after == DecreeStatus.REJECTED)) {
            DecreeHistoryLogger.logStatusChange(d, after, "VOTE_FINAL");
        }
        Object quorumText = minVotesRequired > 0 ? " \u00a77Quorum: \u00a7e" + votesCast + "/" + minVotesRequired + (hasQuorum ? " \u00a7a(REACHED)" : " \u00a7c(NOT reached)") : " \u00a77Quorum: \u00a78none required";
        Object extraStatus = "";
        if (before != after && after != DecreeStatus.VOTING) {
            extraStatus = " \u00a77[Final: \u00a7e" + String.valueOf((Object)after) + "\u00a77]";
        }
        String msg = "\u00a7a[Decrees] " + seat.displayName + " voted \u00a7e" + String.valueOf((Object)choice) + "\u00a7a on decree \u00a7e#" + d.id + "\u00a7a. (Yes: " + yes + ", No: " + no + ", Abstain: " + abstain + ", Votes: " + votesCast + "/" + totalActiveSeats + ")" + (String)quorumText + (String)extraStatus;
        src.method_45068((class_2561)class_2561.method_43470((String)msg));
        if (before != after && after != DecreeStatus.VOTING) {
            src.method_9211().method_3760().method_43514((class_2561)class_2561.method_43470((String)("\u00a76[Decrees] Decree \u00a7e#" + d.id + "\u00a76 (" + d.title + ") is now \u00a7e" + String.valueOf((Object)after) + "\u00a76.")), false);
            CouncilCommands.notifyCouncilDecreeFinal(src, d);
        }
        return 1;
    }
}

