/*
 * Decompiled with CFR 0.152.
 */
package com.spacewaltz.decrees.council;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.spacewaltz.decrees.council.CouncilConfigData;
import com.spacewaltz.decrees.council.SeatDefinition;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;

public class CouncilConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("decrees_of_the_six");
    private static final Path CONFIG_PATH = CONFIG_DIR.resolve("council.json");
    private static CouncilConfigData INSTANCE;

    public static CouncilConfigData get() {
        if (INSTANCE == null) {
            CouncilConfig.load();
        }
        return INSTANCE;
    }

    public static void load() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                CouncilConfigData defaults = new CouncilConfigData();
                defaults.seats.add(new SeatDefinition("overseer_regent", "Overseer-Regent", null));
                defaults.seats.add(new SeatDefinition("grand_artifex", "Grand Artifex of Stone", null));
                defaults.seats.add(new SeatDefinition("vox_imperion", "Vox Imperion", null));
                defaults.seats.add(new SeatDefinition("ledger_exarch", "Exarch of the Ledger", null));
                defaults.seats.add(new SeatDefinition("luminous_hierophant", "Hierophant of the Luminous Archive", null));
                defaults.seats.add(new SeatDefinition("justiciar_praetor", "Justiciar-Praetor", null));
                INSTANCE = defaults;
                CouncilConfig.save();
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                CouncilConfigData data = (CouncilConfigData)GSON.fromJson((Reader)reader, CouncilConfigData.class);
                if (data == null || data.seats == null) {
                    data = new CouncilConfigData();
                }
                INSTANCE = data;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            INSTANCE = new CouncilConfigData();
        }
    }

    public static void save() {
        if (INSTANCE == null) {
            return;
        }
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static SeatDefinition findSeat(String id) {
        for (SeatDefinition seat : CouncilConfig.get().seats) {
            if (!seat.id.equalsIgnoreCase(id)) continue;
            return seat;
        }
        return null;
    }

    public static SeatDefinition findSeatByHolder(UUID uuid) {
        for (SeatDefinition seat : CouncilConfig.get().seats) {
            if (!uuid.equals(seat.holderUuid)) continue;
            return seat;
        }
        return null;
    }
}

