/*
 * Decompiled with CFR 0.152.
 */
package com.spacewaltz.decrees.decree;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.spacewaltz.decrees.decree.Decree;
import com.spacewaltz.decrees.decree.DecreeData;
import com.spacewaltz.decrees.decree.DecreeStatus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class DecreeStore {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path DATA_DIR = FabricLoader.getInstance().getConfigDir().resolve("decrees_of_the_six");
    private static final Path DATA_PATH = DATA_DIR.resolve("decrees.json");
    private static DecreeData INSTANCE;

    public static DecreeData get() {
        if (INSTANCE == null) {
            DecreeStore.load();
        }
        return INSTANCE;
    }

    public static void load() {
        try {
            if (!Files.exists(DATA_DIR, new LinkOption[0])) {
                Files.createDirectories(DATA_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(DATA_PATH, new LinkOption[0])) {
                INSTANCE = new DecreeData();
                DecreeStore.save();
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(DATA_PATH);){
                DecreeData data = (DecreeData)GSON.fromJson((Reader)reader, DecreeData.class);
                if (data == null || data.decrees == null) {
                    data = new DecreeData();
                }
                INSTANCE = data;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            INSTANCE = new DecreeData();
        }
    }

    public static void save() {
        if (INSTANCE == null) {
            return;
        }
        try {
            if (!Files.exists(DATA_DIR, new LinkOption[0])) {
                Files.createDirectories(DATA_DIR, new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(DATA_PATH, new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Decree createDecree(String title, String createdBySeatId) {
        DecreeData data = DecreeStore.get();
        int maxId = 0;
        for (Decree d : data.decrees) {
            if (d.id <= maxId) continue;
            maxId = d.id;
        }
        Decree decree = new Decree();
        decree.id = maxId + 1;
        decree.title = title;
        decree.description = "";
        decree.category = "";
        decree.expiresAt = null;
        decree.createdBySeatId = createdBySeatId;
        decree.status = DecreeStatus.DRAFT;
        decree.createdAt = System.currentTimeMillis();
        decree.votingOpenedAt = null;
        data.decrees.add(decree);
        DecreeStore.save();
        return decree;
    }

    public static Decree find(int id) {
        for (Decree d : DecreeStore.get().decrees) {
            if (d.id != id) continue;
            return d;
        }
        return null;
    }
}

