/*
 * Decompiled with CFR 0.152.
 */
package com.spacewaltz.decrees.decree;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.spacewaltz.decrees.decree.VotingRulesData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class VotingRulesConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("decrees_of_the_six");
    private static final Path CONFIG_PATH = CONFIG_DIR.resolve("voting_rules.json");
    private static VotingRulesData INSTANCE;

    public static VotingRulesData get() {
        if (INSTANCE == null) {
            VotingRulesConfig.loadFromDisk();
        }
        return INSTANCE;
    }

    public static void load() {
        VotingRulesConfig.loadFromDisk();
    }

    private static void loadFromDisk() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                INSTANCE = new VotingRulesData();
                VotingRulesConfig.save();
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                VotingRulesData data = (VotingRulesData)GSON.fromJson((Reader)reader, VotingRulesData.class);
                if (data == null) {
                    data = new VotingRulesData();
                }
                INSTANCE = data;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            INSTANCE = new VotingRulesData();
        }
    }

    public static void save() {
        if (INSTANCE == null) {
            return;
        }
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

