package io.github.apace100.origins.badge;

import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.registry.DataObject;
import io.github.apace100.calio.registry.DataObjectFactory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_5684;
import java.util.List;

public interface Badge extends DataObject<Badge> {
    
    class_2960 spriteId();
    
    boolean hasTooltip();
    
    @Environment(EnvType.CLIENT)
    List<class_5684> getTooltipComponents(PowerType<?> powerType, int widthLimit, float time, class_327 textRenderer);

    SerializableData.Instance toData(SerializableData.Instance instance);

    BadgeFactory getBadgeFactory();

    @Override
    default DataObjectFactory<Badge> getFactory() {
        return this.getBadgeFactory();
    }

    default void writeBuf(class_2540 buf) {
        DataObjectFactory<Badge> factory = this.getFactory();
        buf.method_10812(this.getBadgeFactory().id());
        factory.getData().write(buf, factory.toData(this));
    }
    
}
