package io.github.apace100.origins.badge;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableData.Instance;
import io.github.apace100.calio.registry.DataObjectFactory;
import java.util.function.Function;
import net.minecraft.class_2960;

public record BadgeFactory(class_2960 id, SerializableData data, Function<SerializableData.Instance, Badge> factory) implements DataObjectFactory<Badge> {

    @Override
    public SerializableData getData() {
        return data;
    }

    @Override
    public Badge fromData(SerializableData.Instance instance) {
        return factory.apply(instance);
    }

    @Override
    public SerializableData.Instance toData(Badge badge) {
        return badge.toData(data.new Instance());
    }

}