package io.github.apace100.origins.badge;

import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.screen.tooltip.CraftingRecipeTooltipComponent;
import org.jetbrains.annotations.Nullable;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_5684;

public record CraftingRecipeBadge(class_2960 spriteId,
                                  class_1860<class_1715> recipe,
                                  @Nullable class_2561 prefix,
                                  @Nullable class_2561 suffix) implements Badge {

    public CraftingRecipeBadge(SerializableData.Instance instance) {
        this(instance.getId("sprite"),
            instance.get("recipe"),
            instance.get("prefix"),
            instance.get("suffix"));
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    public class_2371<class_1799> peekInputs(float time) {
        int seed = class_3532.method_15375(time / 30);
        class_2371<class_1799> inputs = class_2371.method_10213(9, class_1799.field_8037);
        List<class_1856> ingredients = this.recipe.method_8117();
        for(int index = 0; index < ingredients.size(); ++index) {
            class_1799[] stacks = ingredients.get(index).method_8105();
            if(stacks.length > 0) inputs.set(index, stacks[seed % stacks.length]);
        }
        return inputs;
    }

    @Override
    public List<class_5684> getTooltipComponents(PowerType<?> powerType, int widthLimit, float time, class_327 textRenderer) {
        List<class_5684> tooltips = new LinkedList<>();
        if(class_310.method_1551().field_1687 == null) {
            Origins.LOGGER.warn("Could not construct crafting recipe badge, because world was null");
            return tooltips;
        }
        class_5455 dynamicRegistryManager = class_310.method_1551().field_1687.method_30349();
        int recipeWidth = (class_1860<?>)this.recipe instanceof class_1869 shapedRecipe ? shapedRecipe.method_8150() : 3;
        if(class_310.method_1551().field_1690.field_1827) {
            class_2561 recipeIdText = ((class_5250)class_2561.method_30163(recipe.method_8114().toString())).method_27692(class_124.field_1063);
            widthLimit = Math.max(130, textRenderer.method_27525(recipeIdText));
            if(prefix != null) TooltipBadge.addLines(tooltips, prefix, textRenderer, widthLimit);
            tooltips.add(new CraftingRecipeTooltipComponent(recipeWidth, this.peekInputs(time), this.recipe.method_8110(dynamicRegistryManager)));
            if(suffix != null) TooltipBadge.addLines(tooltips, suffix, textRenderer, widthLimit);
            TooltipBadge.addLines(tooltips, recipeIdText, textRenderer, widthLimit);
        } else {
            widthLimit = 130;
            if(prefix != null) TooltipBadge.addLines(tooltips, prefix, textRenderer, widthLimit);
            tooltips.add(new CraftingRecipeTooltipComponent(recipeWidth, this.peekInputs(time), this.recipe.method_8110(dynamicRegistryManager)));
            if(suffix != null) TooltipBadge.addLines(tooltips, suffix, textRenderer, widthLimit);
        }
        return tooltips;
    }

    @Override
    public SerializableData.Instance toData(SerializableData.Instance instance) {
        instance.set("sprite", spriteId);
        instance.set("recipe", recipe);
        instance.set("prefix", prefix);
        instance.set("suffix", suffix);
        return instance;
    }

    @Override
    public BadgeFactory getBadgeFactory() {
        return BadgeFactories.CRAFTING_RECIPE;
    }

}
