package io.github.apace100.origins.component;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ModifyPlayerSpawnPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.OriginsCallbackPower;
import io.github.apace100.origins.registry.ModComponents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public interface OriginComponent extends AutoSyncedComponent {


	HashMap<OriginLayer, Origin> getOrigins();
	Origin getOrigin(OriginLayer layer);

	boolean hasSelectionInvulnerability();
	boolean isSelectingOrigin();
	boolean hasOrigin(OriginLayer layer);
	boolean hasAllOrigins();
	boolean hadOriginBefore();

	void selectingOrigin(boolean selectingOrigin);
	void setOrigin(OriginLayer layer, Origin origin);

	void sync();

	static void sync(class_1657 player) {
		ModComponents.ORIGIN.sync(player);
		PowerHolderComponent.KEY.sync(player);
	}

	static void onChosen(class_1657 player, boolean hadOriginBefore) {
		if(!hadOriginBefore) {
			PowerHolderComponent.getPowers(player, ModifyPlayerSpawnPower.class).forEach(ModifyPlayerSpawnPower::teleportToModifiedSpawn);
		}
		PowerHolderComponent.getPowers(player, OriginsCallbackPower.class).forEach(p -> p.onChosen(hadOriginBefore));
	}

	static void partialOnChosen(class_1657 player, boolean hadOriginBefore, Origin origin) {
		PowerHolderComponent powerHolder = PowerHolderComponent.KEY.get(player);
		for(PowerType<?> powerType : powerHolder.getPowersFromSource(origin.getIdentifier())) {
			Power p = powerHolder.getPower(powerType);
			if(p instanceof ModifyPlayerSpawnPower && !hadOriginBefore) {
				((ModifyPlayerSpawnPower)p).teleportToModifiedSpawn();
			} else
			if(p instanceof OriginsCallbackPower) {
				((OriginsCallbackPower)p).onChosen(hadOriginBefore);
			}
		}
	}

	default boolean checkAutoChoosingLayers(class_1657 player, boolean includeDefaults) {
		boolean choseOneAutomatically = false;
		ArrayList<OriginLayer> layers = new ArrayList<>();
		for(OriginLayer layer : OriginLayers.getLayers()) {
			if(layer.isEnabled()) {
				layers.add(layer);
			}
		}
		Collections.sort(layers);
		for(OriginLayer layer : layers) {
			boolean shouldContinue = false;
			if (layer.isEnabled() && !hasOrigin(layer)) {
				if (includeDefaults && layer.hasDefaultOrigin()) {
					setOrigin(layer, OriginRegistry.get(layer.getDefaultOrigin()));
					choseOneAutomatically = true;
					shouldContinue = true;
				} else if (layer.getOriginOptionCount(player) == 1 && layer.shouldAutoChoose()) {
					List<Origin> origins = layer.getOrigins(player).stream().map(OriginRegistry::get).filter(Origin::isChoosable).collect(Collectors.toList());
					if (origins.size() == 0) {
						List<class_2960> randomOrigins = layer.getRandomOrigins(player);
						setOrigin(layer, OriginRegistry.get(randomOrigins.get(player.method_6051().method_43048(randomOrigins.size()))));
					} else {
						setOrigin(layer, origins.get(0));
					}
					choseOneAutomatically = true;
					shouldContinue = true;
				} else if(layer.getOriginOptionCount(player) == 0) {
					shouldContinue = true;
				}
			} else {
				shouldContinue = true;
			}
			if(!shouldContinue) {
				break;
			}
		}
		return choseOneAutomatically;
	}
}
