package io.github.apace100.origins.content;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModComponents;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.util.NbtType;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.util.*;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrbOfOriginItem extends class_1792 {

    public OrbOfOriginItem() {
        super(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8903));
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if(!world.field_9236) {
            OriginComponent component = ModComponents.ORIGIN.get(user);
            Map<OriginLayer, Origin> targets = getTargets(stack);
            if(targets.size() > 0) {
                for(Map.Entry<OriginLayer, Origin> target : targets.entrySet()) {
                    component.setOrigin(target.getKey(), target.getValue());
                }
            } else {
                for (OriginLayer layer : OriginLayers.getLayers()) {
                    if(layer.isEnabled()) {
                        component.setOrigin(layer, Origin.EMPTY);
                    }
                }
            }
            boolean originAutomaticallyAssigned = component.checkAutoChoosingLayers(user, false);
            int originOptions = OriginLayers.getOriginOptionCount(user);

            component.selectingOrigin(!originAutomaticallyAssigned || originOptions > 0);
            component.sync();
            class_2540 data = new class_2540(Unpooled.buffer());
            data.writeBoolean(false);
            ServerPlayNetworking.send((class_3222) user, ModPackets.OPEN_ORIGIN_SCREEN, data);
        }
        if(!user.method_7337()) {
            stack.method_7934(1);
        }
        return class_1271.method_22428(stack);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        Map<OriginLayer, Origin> targets = getTargets(stack);
        for(Map.Entry<OriginLayer, Origin> target : targets.entrySet()) {
            if(target.getValue() == Origin.EMPTY) {
                tooltip.add(class_2561.method_43469("item.origins.orb_of_origin.layer_generic",
                    class_2561.method_43471(target.getKey().getTranslationKey())).method_27692(class_124.field_1080));
            } else {
                tooltip.add(class_2561.method_43469("item.origins.orb_of_origin.layer_specific",
                    class_2561.method_43471(target.getKey().getTranslationKey()),
                    target.getValue().getName()).method_27692(class_124.field_1080));
            }
        }
    }

    private Map<OriginLayer, Origin> getTargets(class_1799 stack) {
        HashMap<OriginLayer, Origin> targets = new HashMap<>();
        if(!stack.method_7985()) {
            return targets;
        }
        class_2487 nbt = stack.method_7969();
        if(!nbt.method_10573("Targets", NbtType.LIST)) {
            return targets;
        }
        class_2499 targetList = (class_2499)nbt.method_10580("Targets");
        for (class_2520 nbtElement : targetList) {
            if(nbtElement instanceof class_2487 targetNbt) {
                if(targetNbt.method_10573("Layer", NbtType.STRING)) {
                    try {
                        class_2960 id = new class_2960(targetNbt.method_10558("Layer"));
                        OriginLayer layer = OriginLayers.getLayer(id);
                        Origin origin = Origin.EMPTY;
                        if(targetNbt.method_10573("Origin", NbtType.STRING)) {
                            class_2960 originId = new class_2960(targetNbt.method_10558("Origin"));
                            origin = OriginRegistry.get(originId);
                        }
                        if(layer.isEnabled() && (layer.contains(origin) || origin.isSpecial())) {
                            targets.put(layer, origin);
                        }
                    } catch (Exception e) {
                        // no op
                    }
                }
            }
        }
        return targets;
    }
}
