package io.github.apace100.origins.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.registry.ModComponents;
import net.minecraft.class_1297;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1297.class)
public abstract class SelectionInvulnerabilityMixin {


    @ModifyReturnValue(method = "isInvulnerableTo", at = @At("RETURN"))
    private boolean origin$makeOriginInvulnerable(boolean original) {
        return original || ModComponents.ORIGIN.maybeGet(this).map(OriginComponent::hasSelectionInvulnerability).orElse(false);
    }
}
