package io.github.apace100.origins.origin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class OriginUpgrade {

    private final class_2960 advancementCondition;
    private final class_2960 upgradeToOrigin;
    private final String announcement;

    public OriginUpgrade(class_2960 advancementCondition, class_2960 upgradeToOrigin, String announcement) {
        this.advancementCondition = advancementCondition;
        this.upgradeToOrigin = upgradeToOrigin;
        this.announcement = announcement;
    }

    public class_2960 getAdvancementCondition() {
        return advancementCondition;
    }

    public class_2960 getUpgradeToOrigin() {
        return upgradeToOrigin;
    }

    public String getAnnouncement() {
        return announcement;
    }

    public void write(class_2540 buffer) {
        buffer.method_10812(advancementCondition);
        buffer.method_10812(upgradeToOrigin);
        buffer.method_10814(announcement);
    }

    public static OriginUpgrade read(class_2540 buffer) {
        class_2960 condition = buffer.method_10810();
        class_2960 origin = buffer.method_10810();
        String announcement = buffer.method_10800(32767);
        return new OriginUpgrade(condition, origin, announcement);
    }

    public static OriginUpgrade fromJson(JsonElement jsonElement) {
        if(!jsonElement.isJsonObject()) {
            throw new JsonParseException("Origin upgrade needs to be a JSON object.");
        }
        JsonObject json = jsonElement.getAsJsonObject();
        JsonElement condition;
        JsonElement origin;
        if(json.has("condition") && (condition = json.get("condition")).isJsonPrimitive()
            && json.has("origin") && (origin = json.get("origin")).isJsonPrimitive()) {
            class_2960 conditionId = class_2960.method_12829(condition.getAsString());
            class_2960 originId = class_2960.method_12829(origin.getAsString());
            String announcement = "";
            if(json.has("announcement")) {
                JsonElement anno = json.get("announcement");
                if(anno.isJsonPrimitive()) {
                    announcement = anno.getAsString();
                }
            }
            return new OriginUpgrade(conditionId, originId, announcement);
        } else {
            throw new JsonParseException("Origin upgrade JSON requires \"condition\" string and \"origin\" string.");
        }
    }
}
