package io.github.apace100.origins.power;

import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.registry.ModComponents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class OriginsEntityConditions {

    @SuppressWarnings("unchecked")
    public static void register() {
        register(new ConditionFactory<>(Origins.identifier("origin"), new SerializableData()
            .add("origin", SerializableDataTypes.IDENTIFIER)
            .add("layer", SerializableDataTypes.IDENTIFIER, null),
            (data, entity) -> {
                if(entity instanceof class_1657) {OriginComponent component = ModComponents.ORIGIN.get(entity);
                    class_2960 originId = data.getId("origin");
                    if(data.isPresent("layer")) {
                        class_2960 layerId = data.getId("layer");
                        OriginLayer layer = OriginLayers.getLayer(layerId);
                        if(layer == null) {
                            return false;
                        } else {
                            Origin origin = component.getOrigin(layer);
                            if(origin != null) {
                                return origin.getIdentifier().equals(originId);
                            }
                            return false;
                        }
                    } else {
                        return component.getOrigins().values().stream().anyMatch(o -> o.getIdentifier().equals(originId));
                    }
                } else {
                    return false;
                }
            }));
    }

    private static void register(ConditionFactory<class_1297> conditionFactory) {
        class_2378.method_10230(ApoliRegistries.ENTITY_CONDITION, conditionFactory.getSerializerId(), conditionFactory);
    }
}
