package io.github.apace100.origins.screen;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModItems;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import java.util.ArrayList;
import java.util.List;

public class ChooseOriginScreen extends OriginDisplayScreen {

	private final ArrayList<OriginLayer> layerList;
	private int currentLayerIndex = 0;
	private int currentOrigin = 0;
	private final List<Origin> originSelection;
	private int maxSelection = 0;

	private Origin randomOrigin;
	
	public ChooseOriginScreen(ArrayList<OriginLayer> layerList, int currentLayerIndex, boolean showDirtBackground) {
		super(class_2561.method_43471(Origins.MODID + ".screen.choose_origin"), showDirtBackground);
		this.layerList = layerList;
		this.currentLayerIndex = currentLayerIndex;
		this.originSelection = new ArrayList<>(10);
		class_1657 player = class_310.method_1551().field_1724;
		OriginLayer currentLayer = layerList.get(currentLayerIndex);
		List<class_2960> originIdentifiers = currentLayer.getOrigins(player);
		originIdentifiers.forEach(originId -> {
			Origin origin = OriginRegistry.get(originId);
			if(origin.isChoosable()) {
				class_1799 displayItem = origin.getDisplayItem();
				if(displayItem.method_7909() == class_1802.field_8575) {
					if(!displayItem.method_7985() || !displayItem.method_7969().method_10545("SkullOwner")) {
						displayItem.method_7948().method_10582("SkullOwner", player.method_5476().getString());
					}
				}
				this.originSelection.add(origin);
			}
		});
		originSelection.sort((a, b) -> {
			int impDelta = a.getImpact().getImpactValue() - b.getImpact().getImpactValue();
			return impDelta == 0 ? a.getOrder() - b.getOrder() : impDelta;
		});
		maxSelection = originSelection.size();
		if(currentLayer.isRandomAllowed() && currentLayer.getRandomOrigins(player).size() > 0) {
			maxSelection += 1;
		}
		if(maxSelection == 0) {
			openNextLayerScreen();
		}
		Origin newOrigin = getCurrentOriginInternal();
		showOrigin(newOrigin, layerList.get(currentLayerIndex), newOrigin == randomOrigin);
	}

	private void openNextLayerScreen() {
		class_310.method_1551().method_1507(new WaitForNextLayerScreen(layerList, currentLayerIndex, this.showDirtBackground));
	}

	@Override
	public boolean method_25422() {
		return false;
	}

	@Override
	protected void method_25426() {
		super.method_25426();
		if(maxSelection > 1) {
			method_37063(class_4185.method_46430(class_2561.method_30163("<"), b -> {
				currentOrigin = (currentOrigin - 1 + maxSelection) % maxSelection;
				Origin newOrigin = getCurrentOriginInternal();
				showOrigin(newOrigin, layerList.get(currentLayerIndex), newOrigin == randomOrigin);
			}).method_46434(guiLeft - 40, this.field_22790 / 2 - 10, 20, 20).method_46431());
			method_37063(class_4185.method_46430(class_2561.method_30163(">"), b -> {
				currentOrigin = (currentOrigin + 1) % maxSelection;
				Origin newOrigin = getCurrentOriginInternal();
				showOrigin(newOrigin, layerList.get(currentLayerIndex), newOrigin == randomOrigin);
			}).method_46434(guiLeft + windowWidth + 20, this.field_22790 / 2 - 10, 20, 20).method_46431());
		}
		method_37063(class_4185.method_46430(class_2561.method_43471(Origins.MODID + ".gui.select"), b -> {
			class_2540 buf = new class_2540(Unpooled.buffer());
			if(currentOrigin == originSelection.size()) {
				buf.method_10814(layerList.get(currentLayerIndex).getIdentifier().toString());
				ClientPlayNetworking.send(ModPackets.CHOOSE_RANDOM_ORIGIN, buf);
			} else {
				buf.method_10814(getCurrentOrigin().getIdentifier().toString());
				buf.method_10814(layerList.get(currentLayerIndex).getIdentifier().toString());
				ClientPlayNetworking.send(ModPackets.CHOOSE_ORIGIN, buf);
			}
			openNextLayerScreen();
		}).method_46434(guiLeft + windowWidth / 2 - 50, guiTop + windowHeight + 5, 100, 20).method_46431());
	}

	@Override
	protected class_2561 getTitleText() {
		if (getCurrentLayer().shouldOverrideChooseOriginTitle()) {
			return class_2561.method_43471(getCurrentLayer().getTitleChooseOriginTranslationKey());
		}
		return class_2561.method_43469(Origins.MODID + ".gui.choose_origin.title", class_2561.method_43471(getCurrentLayer().getTranslationKey()));
	}

	private Origin getCurrentOriginInternal() {
		if(currentOrigin == originSelection.size()) {
			if(randomOrigin == null) {
				initRandomOrigin();
			}
			return randomOrigin;
		}
		return originSelection.get(currentOrigin);
	}

	private void initRandomOrigin() {
		this.randomOrigin = new Origin(Origins.identifier("random"), new class_1799(ModItems.ORB_OF_ORIGIN), Impact.NONE, -1, Integer.MAX_VALUE);
		class_5250 randomOriginText = (class_5250)class_2561.method_30163("");
		List<class_2960> randoms = layerList.get(currentLayerIndex).getRandomOrigins(class_310.method_1551().field_1724);
		randoms.sort((ia, ib) -> {
			Origin a = OriginRegistry.get(ia);
			Origin b = OriginRegistry.get(ib);
			int impDelta = a.getImpact().getImpactValue() - b.getImpact().getImpactValue();
			return impDelta == 0 ? a.getOrder() - b.getOrder() : impDelta;
		});
		for(class_2960 id : randoms) {
			randomOriginText.method_10852(OriginRegistry.get(id).getName());
			randomOriginText.method_10852(class_2561.method_30163("\n"));
		}
		setRandomOriginText(randomOriginText);
	}

	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
		if(maxSelection == 0) {
			openNextLayerScreen();
			return;
		}
		super.method_25394(context, mouseX, mouseY, delta);
	}
}
