package io.github.apace100.origins.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.mixin.DrawContextAccessor;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8001;

public class OriginDisplayScreen extends class_437 {

    private static final class_2960 WINDOW = new class_2960(Origins.MODID, "textures/gui/choose_origin.png");
    private Origin origin;
    private OriginLayer layer;
    private boolean isOriginRandom;
    private class_2561 randomOriginText;

    protected static final int windowWidth = 176;
    protected static final int windowHeight = 182;
    protected int scrollPos = 0;
    private int currentMaxScroll = 0;
    private float time = 0;

    protected int guiTop, guiLeft;

    protected final boolean showDirtBackground;

    private final LinkedList<RenderedBadge> renderedBadges = new LinkedList<>();

    public OriginDisplayScreen(class_2561 title, boolean showDirtBackground) {
        super(title);
        this.showDirtBackground = showDirtBackground;
    }

    public void showOrigin(Origin origin,OriginLayer layer, boolean isRandom) {
        this.origin = origin;
        this.layer = layer;
        this.isOriginRandom = isRandom;
        this.scrollPos = 0;
        this.time = 0;
    }

    public void setRandomOriginText(class_2561 text) {
        this.randomOriginText = text;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        guiLeft = (this.field_22789 - windowWidth) / 2;
        guiTop = (this.field_22790 - windowHeight) / 2;
    }

    public Origin getCurrentOrigin() {
        return origin;
    }

    public OriginLayer getCurrentLayer() {
        return layer;
    }

    @Override
    public void method_25420(class_332 context) {
        if(showDirtBackground) {
            super.method_25434(context);
        } else {
            super.method_25420(context);
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        renderedBadges.clear();
        this.time += delta;
        this.method_25420(context);
        this.renderOriginWindow(context, mouseX, mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
        if(origin != null) {
            renderScrollbar(context, mouseX, mouseY);
            renderBadgeTooltip(context, mouseX, mouseY);
        }
    }

    private void renderScrollbar(class_332 context, int mouseX, int mouseY) {
        if(!canScroll()) {
            return;
        }
        context.method_25302(WINDOW, guiLeft + 155, guiTop + 35, 188, 24, 8, 134);
        int scrollbarY = 36;
        int maxScrollbarOffset = 141;
        int u = 176;
        float part = scrollPos / (float)currentMaxScroll;
        scrollbarY += (maxScrollbarOffset - scrollbarY) * part;
        if(scrolling) {
            u += 6;
        } else if(mouseX >= guiLeft + 156 && mouseX < guiLeft + 156 + 6) {
            if(mouseY >= guiTop + scrollbarY && mouseY < guiTop + scrollbarY + 27) {
                u += 6;
            }
        }
        context.method_25302(WINDOW, guiLeft + 156, guiTop + scrollbarY, u, 24, 6, 27);
    }

    private boolean scrolling = false;
    private int scrollDragStart = 0;
    private double mouseDragStart = 0;

    private boolean canScroll() {
        return origin != null && currentMaxScroll > 0;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        scrolling = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if(canScroll()) {
            scrolling = false;
            int scrollbarY = 36;
            int maxScrollbarOffset = 141;
            float part = scrollPos / (float)currentMaxScroll;
            scrollbarY += (maxScrollbarOffset - scrollbarY) * part;
            if(mouseX >= guiLeft + 156 && mouseX < guiLeft + 156 + 6) {
                if(mouseY >= guiTop + scrollbarY && mouseY < guiTop + scrollbarY + 27) {
                    scrolling = true;
                    scrollDragStart = scrollbarY;
                    mouseDragStart = mouseY;
                    return true;
                }
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if(this.scrolling) {
            int delta = (int)(mouseY - mouseDragStart);
            int newScrollPos = (int)Math.max(36, Math.min(141, scrollDragStart + delta));
            float part = (newScrollPos - 36) / (float)(141 - 36);
            scrollPos = (int)(part * currentMaxScroll);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void renderBadgeTooltip(class_332 context, int mouseX, int mouseY) {
        for(RenderedBadge rb : renderedBadges) {
            if(mouseX >= rb.x &&
               mouseX < rb.x + 9 &&
               mouseY >= rb.y &&
               mouseY < rb.y + 9 &&
               rb.hasTooltip()) {
                int widthLimit = field_22789 - mouseX - 24;
                ((DrawContextAccessor)context).invokeDrawTooltip(field_22793, rb.getTooltipComponents(field_22793, widthLimit), mouseX, mouseY, class_8001.field_41687);
            }
        }
    }

    protected class_2561 getTitleText() {
        return class_2561.method_30163("Origins");
    }

    private void renderOriginWindow(class_332 context, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        renderWindowBackground(context, 16, 0);
        if(origin != null) {
            //context.enableScissor(guiLeft, guiTop, guiLeft + windowWidth, guiTop + windowHeight);
            this.renderOriginContent(context, mouseX, mouseY);
            //context.disableScissor();
        }
        context.method_25291(WINDOW, guiLeft, guiTop, 1, 0, 0, windowWidth, windowHeight, 256, 256);
        if(origin != null) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0, 0, 5);
            renderOriginName(context);
            RenderSystem.setShaderTexture(0, WINDOW);
            this.renderOriginImpact(context, mouseX, mouseY);
            context.method_51448().method_22909();
            class_2561 title = getTitleText();
            context.method_25300(this.field_22793, title.getString(), field_22789 / 2, guiTop - 15, 0xFFFFFF);
        }
        RenderSystem.disableBlend();
    }

    private void renderOriginImpact(class_332 context, int mouseX, int mouseY) {
        Impact impact = getCurrentOrigin().getImpact();
        int impactValue = impact.getImpactValue();
        int wOffset = impactValue * 8;
        for(int i = 0; i < 3; i++) {
            if(i < impactValue) {
                context.method_25302(WINDOW, guiLeft + 128 + i * 10, guiTop + 19, windowWidth + wOffset, 16, 8, 8);
            } else {
                context.method_25302(WINDOW, guiLeft + 128 + i * 10, guiTop + 19, windowWidth, 16, 8, 8);
            }
        }
        if(mouseX >= guiLeft + 128 && mouseX <= guiLeft + 158
            && mouseY >= guiTop + 19 && mouseY <= guiTop + 27) {
            class_5250 ttc = class_2561.method_43471(Origins.MODID + ".gui.impact.impact").method_27693(": ").method_10852(impact.getTextComponent());
            context.method_51438(this.field_22793, ttc, mouseX, mouseY);
        }
    }

    private void renderOriginName(class_332 context) {
        class_5348 originName = field_22793.method_1714(getCurrentOrigin().getName(), windowWidth - 36);
        context.method_25303(field_22793, originName.getString(), guiLeft + 39, guiTop + 19, 0xFFFFFF);
        class_1799 is = getCurrentOrigin().getDisplayItem();
        context.method_51427(is, guiLeft + 15, guiTop + 15);
    }

    private void renderWindowBackground(class_332 context, int offsetYStart, int offsetYEnd) {
        int border = 13;
        int endX = guiLeft + windowWidth - border;
        int endY = guiTop + windowHeight - border;
        for(int x = guiLeft; x < endX; x += 16) {
            for(int y = guiTop + offsetYStart; y < endY + offsetYEnd; y += 16) {
                context.method_25302(WINDOW, x, y, windowWidth, 0, Math.max(16, endX - x), Math.max(16, endY + offsetYEnd - y));
            }
        }
    }

    @Override
    public boolean method_25401(double x, double y, double z) {
        boolean retValue = super.method_25401(x, y, z);
        int np = this.scrollPos - (int)z * 4;
        this.scrollPos = np < 0 ? 0 : Math.min(np, this.currentMaxScroll);
        return retValue;
    }

    private void renderOriginContent(class_332 context, int mouseX, int mouseY) {

        int textWidth = windowWidth - 48;
        // Without this code, the text may not cover the whole width of the window
        // if the scrollbar isn't shown. However with this code, you'll see 1 frame
        // of misaligned text because the text length (and whether scrolling is enabled)
        // is only evaluated on first render. :(
        /*if(!canScroll()) {
            textWidth += 12;
        }*/

        Origin origin = getCurrentOrigin();
        int x = guiLeft + 18;
        int y = guiTop + 50;
        int startY = y;
        int endY = y - 72 + windowHeight;
        y -= scrollPos;

        class_2561 orgDesc = origin.getDescription();
        List<class_5481> descLines = field_22793.method_1728(orgDesc, textWidth);
        for(class_5481 line : descLines) {
            if(y >= startY - 18 && y <= endY + 12) {
                context.method_51430(field_22793, line, x + 2, y - 6, 0xCCCCCC, false);
            }
            y += 12;
        }

        if(isOriginRandom) {
            List<class_5481> drawLines = field_22793.method_1728(randomOriginText, textWidth);
            for(class_5481 line : drawLines) {
                y += 12;
                if(y >= startY - 24 && y <= endY + 12) {
                    context.method_51430(field_22793, line, x + 2, y, 0xCCCCCC, false);
                }
            }
            y += 14;
        } else {
            for(PowerType<?> p : origin.getPowerTypes()) {
                if(p.isHidden()) {
                    continue;
                }
                class_5481 name = class_2477.method_10517().method_30934(field_22793.method_1714(p.getName().method_27692(class_124.field_1073), textWidth));
                class_2561 desc = p.getDescription();
                List<class_5481> drawLines = field_22793.method_1728(desc, textWidth);
                if(y >= startY - 24 && y <= endY + 12) {
                    context.method_51430(field_22793, name, x, y, 0xFFFFFF, false);
                    int tw = field_22793.method_30880(name);
                    List<Badge> badges = BadgeManager.getPowerBadges(p.getIdentifier());
                    int xStart = x + tw + 4;
                    int bi = 0;
                    for(Badge badge : badges) {
                        RenderedBadge renderedBadge = new RenderedBadge(p, badge,xStart + 10 * bi, y - 1);
                        renderedBadges.add(renderedBadge);
                        context.method_25290(badge.spriteId(), xStart + 10 * bi, y - 1, 0, 0, 9, 9, 9, 9);
                        bi++;
                    }
                }
                for(class_5481 line : drawLines) {
                    y += 12;
                    if(y >= startY - 24 && y <= endY + 12) {
                        context.method_51430(field_22793, line, x + 2, y, 0xCCCCCC, false);
                    }
                }

                y += 14;

            }
        }
        y += scrollPos;
        currentMaxScroll = y - 14 - (guiTop + 158);
        if(currentMaxScroll < 0) {
            currentMaxScroll = 0;
        }
    }

    private class RenderedBadge {
        private final PowerType<?> powerType;
        private final Badge badge;
        private final int x;
        private final int y;

        public RenderedBadge(PowerType<?> powerType, Badge badge, int x, int y) {
            this.powerType = powerType;
            this.badge = badge;
            this.x = x;
            this.y = y;
        }

        public boolean hasTooltip() {
            return badge.hasTooltip();
        }

        public List<class_5684> getTooltipComponents(class_327 textRenderer, int widthLimit) {
            return badge.getTooltipComponents(powerType, widthLimit, OriginDisplayScreen.this.time, textRenderer);
        }

    }

}
