package io.github.apace100.origins.screen;

import com.google.common.collect.Lists;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.OriginsClient;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.registry.ModComponents;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4185;

public class ViewOriginScreen extends OriginDisplayScreen {

	private final ArrayList<class_3545<OriginLayer, Origin>> originLayers;
	private int currentLayer = 0;
	private class_4185 chooseOriginButton;

	public ViewOriginScreen() {
		super(class_2561.method_43471(Origins.MODID + ".screen.view_origin"), false);
		class_1657 player = class_310.method_1551().field_1724;
		HashMap<OriginLayer, Origin> origins = ModComponents.ORIGIN.get(player).getOrigins();
		originLayers = new ArrayList<>(origins.size());

		origins.forEach((layer, origin) -> {
			class_1799 displayItem = origin.getDisplayItem();
			if(displayItem.method_7909() == class_1802.field_8575) {
				if(!displayItem.method_7985() || !displayItem.method_7969().method_10545("SkullOwner")) {
					displayItem.method_7948().method_10582("SkullOwner", player.method_5476().getString());
				}
			}
			if((origin != Origin.EMPTY || layer.getOriginOptionCount(player) > 0) && !layer.isHidden()) {
				originLayers.add(new class_3545<>(layer, origin));
			}
		});
		originLayers.sort(Comparator.comparing(class_3545::method_15442));
		if(this.originLayers.size() > 0) {
			class_3545<OriginLayer, Origin> current = originLayers.get(currentLayer);
			showOrigin(current.method_15441(), current.method_15442(), false);
		} else {
			showOrigin(null, null, false);
		}
	}

	@Override
	public boolean method_25422() {
		return true;
	}

	@Override
	protected void method_25426() {
		super.method_25426();
        if(originLayers.size() > 0 && OriginsClient.isServerRunningOrigins) {
			method_37063(chooseOriginButton = class_4185.method_46430(class_2561.method_43471(Origins.MODID + ".gui.choose"), b -> {
				class_310.method_1551().method_1507(new ChooseOriginScreen(Lists.newArrayList(originLayers.get(currentLayer).method_15442()), 0, false));
			}).method_46434(guiLeft + windowWidth / 2 - 50, guiTop + windowHeight - 40, 100, 20).method_46431());

			class_1657 player = class_310.method_1551().field_1724;
			chooseOriginButton.field_22763 = chooseOriginButton.field_22764 = originLayers.get(currentLayer).method_15441() == Origin.EMPTY && originLayers.get(currentLayer).method_15442().getOriginOptionCount(player) > 0;
			if(originLayers.size() > 1) {
				method_37063(class_4185.method_46430(class_2561.method_30163("<"), b -> {
					currentLayer = (currentLayer - 1 + originLayers.size()) % originLayers.size();
					class_3545<OriginLayer, Origin> current = originLayers.get(currentLayer);
					showOrigin(current.method_15441(), current.method_15442(), false);
					chooseOriginButton.field_22763 = chooseOriginButton.field_22764 = current.method_15441() == Origin.EMPTY && current.method_15442().getOriginOptionCount(player) > 0;
				}).method_46434(guiLeft - 40,this.field_22790 / 2 - 10, 20, 20).method_46431());
				method_37063(class_4185.method_46430(class_2561.method_30163(">"), b -> {
					currentLayer = (currentLayer + 1) % originLayers.size();
					class_3545<OriginLayer, Origin> current = originLayers.get(currentLayer);
					showOrigin(current.method_15441(), current.method_15442(), false);
					chooseOriginButton.field_22763 = chooseOriginButton.field_22764 = current.method_15441() == Origin.EMPTY && current.method_15442().getOriginOptionCount(player) > 0;
				}).method_46434(guiLeft + windowWidth + 20, this.field_22790 / 2 - 10, 20, 20).method_46431());
			}
		}
		method_37063(class_4185.method_46430(class_2561.method_43471(Origins.MODID + ".gui.close"), b -> {
			class_310.method_1551().method_1507(null);
		}).method_46434(guiLeft + windowWidth / 2 - 50, guiTop + windowHeight + 5, 100, 20).method_46431());
	}
	
	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
		super.method_25394(context, mouseX, mouseY, delta);
		if(originLayers.size() == 0) {
			if(OriginsClient.isServerRunningOrigins) {
				context.method_25300(this.field_22793, class_2561.method_43471(Origins.MODID + ".gui.view_origin.empty").getString(), field_22789 / 2, guiTop + 48, 0xFFFFFF);
			} else {
				context.method_25300(this.field_22793, class_2561.method_43471(Origins.MODID + ".gui.view_origin.not_installed").getString(), field_22789 / 2, guiTop + 48, 0xFFFFFF);
			}
		}
	}

	@Override
	protected class_2561 getTitleText() {
		if (getCurrentLayer().shouldOverrideViewOriginTitle()) {
			return class_2561.method_43471(getCurrentLayer().getTitleViewOriginTranslationKey());
		}
		return class_2561.method_43469(Origins.MODID + ".gui.view_origin.title", class_2561.method_43471(getCurrentLayer().getTranslationKey()));
	}

}
