package io.github.apace100.origins.screen;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.registry.ModComponents;
import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class WaitForNextLayerScreen extends class_437 {

    private final ArrayList<OriginLayer> layerList;
    private final int currentLayerIndex;
    private final boolean showDirtBackground;
    private final int maxSelection;

    protected WaitForNextLayerScreen(ArrayList<OriginLayer> layerList, int currentLayerIndex, boolean showDirtBackground) {
        super(class_2561.method_43473());
        this.layerList = layerList;
        this.currentLayerIndex = currentLayerIndex;
        this.showDirtBackground = showDirtBackground;
        class_1657 player = class_310.method_1551().field_1724;
        OriginLayer currentLayer = layerList.get(currentLayerIndex);
        maxSelection = currentLayer.getOriginOptionCount(player);
    }

    public void openSelection() {
        int index = currentLayerIndex + 1;
        class_1657 player = class_310.method_1551().field_1724;
        OriginComponent component = ModComponents.ORIGIN.get(player);
        while(index < layerList.size()) {
            if(!component.hasOrigin(layerList.get(index)) && layerList.get(index).getOrigins(player).size() > 0) {
                class_310.method_1551().method_1507(new ChooseOriginScreen(layerList, index, showDirtBackground));
                return;
            }
            index++;
        }
        class_310.method_1551().method_1507(null);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if(maxSelection == 0) {
            openSelection();
            return;
        }
        this.method_25420(context);
    }

    @Override
    public void method_25420(class_332 context) {
        if(showDirtBackground) {
            super.method_25434(context);
        } else {
            super.method_25420(context);
        }
    }
}
