package io.github.apace100.origins.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.origin.Origin;
import net.minecraft.class_195;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;

public class ChoseOriginCriterion extends class_4558<ChoseOriginCriterion.Conditions> {

    public static ChoseOriginCriterion INSTANCE = new ChoseOriginCriterion();

    private static final class_2960 ID = new class_2960(Origins.MODID, "chose_origin");

    @Override
    protected Conditions method_27854(JsonObject obj, class_5258 playerPredicate, class_5257 predicateDeserializer) {
        class_2960 id = class_2960.method_12829(class_3518.method_15265(obj, "origin"));
        return new Conditions(playerPredicate, id);
    }

    public void trigger(class_3222 player, Origin origin) {
        this.method_22510(player, (conditions -> conditions.matches(origin)));
    }

    @Override
    public class_2960 method_794() {
        return ID;
    }

    public static class Conditions extends class_195 {
        private final class_2960 originId;

        public Conditions(class_5258 player, class_2960 originId) {
            super(ChoseOriginCriterion.ID, player);
            this.originId = originId;
        }

        public boolean matches(Origin origin) {
            return origin.getIdentifier().equals(originId);
        }

        public JsonObject method_807(class_5267 predicateSerializer) {
            JsonObject jsonObject = super.method_807(predicateSerializer);
            jsonObject.add("origin", new JsonPrimitive(originId.toString()));
            return jsonObject;
        }
    }
}
