package io.github.apace100.origins.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModLoot;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5335;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public class OriginLootCondition implements class_5341 {
    private final class_2960 origin;
    private final class_2960 layer;

    private OriginLootCondition(class_2960 origin) {
        this.origin = origin;
        this.layer = null;
    }

    private OriginLootCondition(class_2960 origin, class_2960 layer) {
        this.origin = origin;
        this.layer = layer;
    }

    public class_5342 method_29325() {
        return ModLoot.ORIGIN_LOOT_CONDITION;
    }

    public boolean test(class_47 lootContext) {
        Optional<OriginComponent> optional = ModComponents.ORIGIN.maybeGet(lootContext.method_296(class_181.field_1226));
        if(optional.isPresent()) {
            OriginComponent component = optional.get();
            HashMap<OriginLayer, Origin> map = component.getOrigins();
            boolean matches = false;
            for (Map.Entry<OriginLayer, Origin> entry: map.entrySet()) {
                if (layer != null) {
                    if (entry.getKey().getIdentifier().equals(layer) && entry.getValue().getIdentifier().equals(origin)) {
                        matches = true;
                        break;
                    }
                }
                else {
                    if (entry.getValue().getIdentifier().equals(origin)) {
                        matches = true;
                        break;
                    }
                }
            }
            return matches;
        }
        return false;
    }

    public static class_5341.class_210 builder(String originId) {
        return builder(new class_2960(originId));
    }

    public static class_5341.class_210 builder(class_2960 origin) {
        return () -> new OriginLootCondition(origin);
    }

    public static class_5341.class_210 builder(String originId, String layerId) {
        return builder(new class_2960(originId), new class_2960(layerId));
    }

    public static class_5341.class_210 builder(class_2960 origin, class_2960 layer) {
        return () -> new OriginLootCondition(origin, layer);
    }

    public static class Serializer implements class_5335<OriginLootCondition> {
        public void toJson(JsonObject jsonObject, OriginLootCondition originLootCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("origin", originLootCondition.origin.toString());
            if (originLootCondition.layer != null) {
                jsonObject.addProperty("layer", originLootCondition.layer.toString());
            }
        }

        public OriginLootCondition method_517(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            class_2960 origin = new class_2960(class_3518.method_15265(jsonObject, "origin"));
            if (jsonObject.has("layer")) {
                class_2960 layer = new class_2960(class_3518.method_15265(jsonObject, "layer"));
                return new OriginLootCondition(origin, layer);
            }
            return new OriginLootCondition(origin);
        }
    }
}
