/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.networking;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModComponents;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;

public class ModPacketsC2S {
    public static void register() {
        if (Origins.config.performVersionCheck) {
            ServerLoginConnectionEvents.QUERY_START.register(ModPacketsC2S::handshake);
            ServerLoginNetworking.registerGlobalReceiver((class_2960)ModPackets.HANDSHAKE, ModPacketsC2S::handleHandshakeReply);
        }
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.CHOOSE_ORIGIN, ModPacketsC2S::chooseOrigin);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.CHOOSE_RANDOM_ORIGIN, ModPacketsC2S::chooseRandomOrigin);
    }

    private static void chooseOrigin(MinecraftServer minecraftServer, class_3222 playerEntity, class_3244 serverPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        String originId = packetByteBuf.method_10800(Short.MAX_VALUE);
        String layerId = packetByteBuf.method_10800(Short.MAX_VALUE);
        minecraftServer.execute(() -> {
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)playerEntity);
            OriginLayer layer = OriginLayers.getLayer(class_2960.method_12829((String)layerId));
            if (!component.hasAllOrigins() && !component.hasOrigin(layer)) {
                class_2960 id = class_2960.method_12829((String)originId);
                if (id != null) {
                    Origin origin = OriginRegistry.get(id);
                    if (origin.isChoosable() && layer.contains(origin, (class_1657)playerEntity)) {
                        boolean hadOriginBefore = component.hadOriginBefore();
                        boolean hadAllOrigins = component.hasAllOrigins();
                        component.setOrigin(layer, origin);
                        component.checkAutoChoosingLayers((class_1657)playerEntity, false);
                        component.sync();
                        if (component.hasAllOrigins() && !hadAllOrigins) {
                            OriginComponent.onChosen((class_1657)playerEntity, hadOriginBefore);
                        }
                        Origins.LOGGER.info("Player " + String.valueOf(playerEntity.method_5476().method_10851()) + " chose Origin: " + originId + ", for layer: " + layerId);
                    } else {
                        Origins.LOGGER.info("Player " + String.valueOf(playerEntity.method_5476().method_10851()) + " tried to choose unchoosable Origin for layer " + layerId + ": " + originId + ".");
                        component.setOrigin(layer, Origin.EMPTY);
                    }
                    ModPacketsC2S.confirmOrigin(playerEntity, layer, component.getOrigin(layer));
                    component.selectingOrigin(false);
                    component.sync();
                } else {
                    Origins.LOGGER.warn("Player " + String.valueOf(playerEntity.method_5476().method_10851()) + " chose unknown origin: " + originId);
                }
            } else {
                Origins.LOGGER.warn("Player " + String.valueOf(playerEntity.method_5476().method_10851()) + " tried to choose origin for layer " + layerId + " while having one already.");
            }
        });
    }

    private static void chooseRandomOrigin(MinecraftServer minecraftServer, class_3222 playerEntity, class_3244 serverPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        String layerId = packetByteBuf.method_10800(Short.MAX_VALUE);
        minecraftServer.execute(() -> {
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)playerEntity);
            OriginLayer layer = OriginLayers.getLayer(class_2960.method_12829((String)layerId));
            if (!component.hasAllOrigins() && !component.hasOrigin(layer)) {
                List<class_2960> randomOrigins = layer.getRandomOrigins((class_1657)playerEntity);
                if (layer.isRandomAllowed() && randomOrigins.size() > 0) {
                    class_2960 randomOrigin = randomOrigins.get(new Random().nextInt(randomOrigins.size()));
                    Origin origin = OriginRegistry.get(randomOrigin);
                    boolean hadOriginBefore = component.hadOriginBefore();
                    boolean hadAllOrigins = component.hasAllOrigins();
                    component.setOrigin(layer, origin);
                    component.checkAutoChoosingLayers((class_1657)playerEntity, false);
                    component.sync();
                    if (component.hasAllOrigins() && !hadAllOrigins) {
                        OriginComponent.onChosen((class_1657)playerEntity, hadOriginBefore);
                    }
                    Origins.LOGGER.info("Player " + String.valueOf(playerEntity.method_5476().method_10851()) + " was randomly assigned the following Origin: " + String.valueOf(randomOrigin) + ", for layer: " + layerId);
                } else {
                    Origins.LOGGER.info("Player " + String.valueOf(playerEntity.method_5476().method_10851()) + " tried to choose a random Origin for layer " + layerId + ", which is not allowed!");
                    component.setOrigin(layer, Origin.EMPTY);
                }
                ModPacketsC2S.confirmOrigin(playerEntity, layer, component.getOrigin(layer));
                component.sync();
            } else {
                Origins.LOGGER.warn("Player " + String.valueOf(playerEntity.method_5476().method_10851()) + " tried to choose origin for layer " + layerId + " while having one already.");
            }
        });
    }

    private static void handleHandshakeReply(MinecraftServer minecraftServer, class_3248 serverLoginNetworkHandler, boolean understood, class_2540 packetByteBuf, ServerLoginNetworking.LoginSynchronizer loginSynchronizer, PacketSender packetSender) {
        if (understood) {
            int clientSemVerLength = packetByteBuf.readInt();
            int[] clientSemVer = new int[clientSemVerLength];
            boolean mismatch = clientSemVerLength != Origins.SEMVER.length;
            for (int i = 0; i < clientSemVerLength; ++i) {
                clientSemVer[i] = packetByteBuf.readInt();
                if (i >= clientSemVerLength - 1 || clientSemVer[i] == Origins.SEMVER[i]) continue;
                mismatch = true;
            }
            if (mismatch) {
                StringBuilder clientVersionString = new StringBuilder();
                for (int i = 0; i < clientSemVerLength; ++i) {
                    clientVersionString.append(clientSemVer[i]);
                    if (i >= clientSemVerLength - 1) continue;
                    clientVersionString.append(".");
                }
                serverLoginNetworkHandler.method_14380((class_2561)class_2561.method_43469((String)"origins.gui.version_mismatch", (Object[])new Object[]{Origins.VERSION, clientVersionString}));
            }
        } else {
            serverLoginNetworkHandler.method_14380(class_2561.method_30163((String)("This server requires you to install the Origins mod (v" + Origins.VERSION + ") to play.")));
        }
    }

    private static void handshake(class_3248 serverLoginNetworkHandler, MinecraftServer minecraftServer, PacketSender packetSender, ServerLoginNetworking.LoginSynchronizer loginSynchronizer) {
        packetSender.sendPacket(ModPackets.HANDSHAKE, PacketByteBufs.empty());
    }

    private static void confirmOrigin(class_3222 player, OriginLayer layer, Origin origin) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(layer.getIdentifier());
        buf.method_10812(origin.getIdentifier());
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.CONFIRM_ORIGIN, (class_2540)buf);
    }
}

