/*
 * Decompiled with CFR 0.152.
 */
package eu.magkari.mc.tool_switcher.mixin;

import eu.magkari.mc.tool_switcher.ToolSwitcher;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1934;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_636.class})
public class MixinClientPlayerInteractionManager {
    @Unique
    private static final Map<class_6862<class_2248>, class_6862<class_1792>> TOOL_MAP = Map.of(class_3481.field_33715, class_3489.field_42614, class_3481.field_33713, class_3489.field_42612, class_3481.field_33716, class_3489.field_42615, class_3481.field_33714, class_3489.field_42613);

    @Inject(method={"attackBlock"}, at={@At(value="HEAD")})
    private void ToolSwitcher$onAttackBlock(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> cir) {
        if (!ToolSwitcher.toggled) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_2680 blockState = client.field_1687.method_8320(pos);
        TOOL_MAP.entrySet().stream().filter(entry -> blockState.method_26164((class_6862)entry.getKey())).map(Map.Entry::getValue).findFirst().ifPresent(toolTag -> this.switchTool((class_6862<class_1792>)toolTag, blockState, client));
    }

    @Inject(method={"breakBlock"}, at={@At(value="TAIL")})
    private void ToolSwitcher$onBreakBlock(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        if (!ToolSwitcher.toggled) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_239 hitResult = client.field_1765;
        if (hitResult == null || hitResult.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_3965 blockHitResult = (class_3965)hitResult;
        class_2338 targetPos = blockHitResult.method_17777();
        class_2680 targetState = client.field_1687.method_8320(targetPos);
        TOOL_MAP.entrySet().stream().filter(entry -> targetState.method_26164((class_6862)entry.getKey())).map(Map.Entry::getValue).findFirst().ifPresent(toolTag -> this.switchTool((class_6862<class_1792>)toolTag, targetState, client));
    }

    @Unique
    private void switchTool(class_6862<class_1792> toolTag, class_2680 state, class_310 client) {
        if (client.field_1724 == null) {
            throw new IllegalStateException("Cannot switch tools: MinecraftClient.player is null.");
        }
        if (client.method_1562() == null) {
            throw new IllegalStateException("Cannot switch tools: MinecraftClient network handler is null.");
        }
        if (Objects.requireNonNull(client.field_1761).method_2920() != class_1934.field_9215) {
            return;
        }
        class_1661 inventory = client.field_1724.method_31548();
        int currentSlot = inventory.method_67532();
        class_1799 currentStack = inventory.method_5438(currentSlot);
        float bestEfficiency = -1.0f;
        int bestSlot = -1;
        class_6880.class_6883 efficiencyEnchantment = client.method_1562().method_29091().method_30530(class_7924.field_41265).method_46747(class_1893.field_9131);
        if (currentStack.method_31573(toolTag)) {
            bestEfficiency = currentStack.method_7924(state);
            int currentEfficiencyLevel = class_1890.method_8225((class_6880)efficiencyEnchantment, (class_1799)currentStack);
            if (currentEfficiencyLevel > 0) {
                bestEfficiency += (float)currentEfficiencyLevel * bestEfficiency * 0.3f;
            }
            bestSlot = currentSlot;
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_31573(toolTag)) continue;
            float efficiency = stack.method_7924(state);
            int efficiencyLevel = class_1890.method_8225((class_6880)efficiencyEnchantment, (class_1799)stack);
            if (efficiencyLevel > 0) {
                efficiency += (float)efficiencyLevel * efficiency * 0.3f;
            }
            if (!(efficiency > bestEfficiency)) continue;
            bestEfficiency = efficiency;
            bestSlot = i;
        }
        if (bestSlot != currentSlot && bestSlot != -1) {
            ToolSwitcher.previousSlot = currentSlot;
            inventory.method_61496(bestSlot);
        }
    }
}

