/*
 * Decompiled with CFR 0.152.
 */
package eu.magkari.mc.tool_switcher;

import eu.magkari.mc.tool_switcher.config.TSConfig;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1934;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public final class ToolSwitcher
implements ClientModInitializer {
    public static final String MOD_ID = "tool-switcher";
    public static int previousSlot = -1;
    public static final Map<class_6862<class_2248>, class_6862<class_1792>> TOOL_MAP = Map.of(class_3481.field_33715, class_3489.field_42614, class_3481.field_33713, class_3489.field_42612, class_3481.field_33716, class_3489.field_42615, class_3481.field_33714, class_3489.field_42613, class_3481.field_55617, class_3489.field_42611);

    public void onInitializeClient() {
        MidnightConfig.init((String)MOD_ID, TSConfig.class);
        class_304 toggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.tool-switcher.toggle", 46, class_304.class_11900.field_62556));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (toggleKey.method_1436()) {
                TSConfig.enabled = !TSConfig.enabled;
                MidnightConfig.write((String)MOD_ID);
                if (!TSConfig.showMessage) continue;
                client.method_44714().method_44736((class_2561)class_2561.method_43471((String)"tool-switcher.msg.state").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43471((String)(TSConfig.enabled ? "options.on" : "options.off")).method_27692(TSConfig.enabled ? class_124.field_1060 : class_124.field_1061)), true);
            }
            if (!TSConfig.enabled || client.field_1724 == null || !TSConfig.goBack) {
                return;
            }
            while (client.field_1690.field_1886.method_1436()) {
                if (previousSlot == -1) continue;
                client.field_1724.method_31548().method_61496(previousSlot);
                previousSlot = -1;
            }
        });
        AttackBlockCallback.EVENT.register((player, world, hand, blockPos, direction) -> {
            if (!TSConfig.enabled || !TSConfig.sneaking || player.method_5715()) {
                return class_1269.field_5811;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1687 == null) {
                return class_1269.field_5811;
            }
            class_2680 blockState = client.field_1687.method_8320(blockPos);
            if (TSConfig.stateIsDisabled(blockState)) {
                return class_1269.field_5811;
            }
            TOOL_MAP.entrySet().stream().filter(entry -> blockState.method_26164((class_6862)entry.getKey())).map(Map.Entry::getValue).findFirst().ifPresent(toolTag -> ToolSwitcher.switchTool((class_6862<class_1792>)toolTag, blockState, client));
            return class_1269.field_5811;
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> {
            if (!TSConfig.enabled || !TSConfig.sneaking || player.method_5715()) {
                return;
            }
            class_310 client = class_310.method_1551();
            class_239 hitResult = client.field_1765;
            if (hitResult == null || hitResult.method_17783() != class_239.class_240.field_1332) {
                return;
            }
            class_2338 targetPos = ((class_3965)hitResult).method_17777();
            class_2680 targetState = world.method_8320(targetPos);
            if (TSConfig.stateIsDisabled(targetState)) {
                return;
            }
            ToolSwitcher.findSwitchTool(targetState, client);
        });
    }

    private static void findSwitchTool(class_2680 state, class_310 client) {
        TOOL_MAP.entrySet().stream().filter(entry -> state.method_26164((class_6862)entry.getKey())).map(Map.Entry::getValue).findFirst().ifPresent(toolTag -> ToolSwitcher.switchTool((class_6862<class_1792>)toolTag, state, client));
    }

    public static void switchTool(class_6862<class_1792> toolTag, class_2680 state, class_310 client) {
        if (client.field_1761 != null && client.field_1761.method_2920() != class_1934.field_9215 || client.method_1562() == null || client.field_1724 == null) {
            return;
        }
        class_1661 inventory = client.field_1724.method_31548();
        int currentSlot = inventory.method_67532();
        class_1799 currentStack = inventory.method_5438(currentSlot);
        float bestEfficiency = -1.0f;
        int bestSlot = -1;
        class_6880.class_6883 efficiencyEnchantment = client.method_1562().method_29091().method_30530(class_7924.field_41265).method_46747(class_1893.field_9131);
        class_6880.class_6883 silkEnchantment = client.method_1562().method_29091().method_30530(class_7924.field_41265).method_46747(class_1893.field_9099);
        class_6880.class_6883 fortuneEnchantment = client.method_1562().method_29091().method_30530(class_7924.field_41265).method_46747(class_1893.field_9130);
        if (currentStack.method_31573(toolTag)) {
            Set enchants;
            bestEfficiency = currentStack.method_7924(state);
            int currentEfficiencyLevel = class_1890.method_8225((class_6880)efficiencyEnchantment, (class_1799)currentStack);
            if (currentEfficiencyLevel > 0) {
                bestEfficiency += (float)currentEfficiencyLevel * bestEfficiency * 0.3f;
            }
            bestSlot = currentSlot;
            if (TSConfig.respectSilkFortune && ((enchants = currentStack.method_58657().method_57534()).contains(silkEnchantment) || enchants.contains(fortuneEnchantment))) {
                return;
            }
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_31573(toolTag) || TSConfig.stackIsDisabled(stack)) continue;
            float efficiency = stack.method_7924(state);
            int efficiencyLevel = class_1890.method_8225((class_6880)efficiencyEnchantment, (class_1799)stack);
            if (efficiencyLevel > 0) {
                efficiency += (float)efficiencyLevel * efficiency * 0.3f;
            }
            if (!(efficiency > bestEfficiency)) continue;
            bestEfficiency = efficiency;
            bestSlot = i;
        }
        if (bestSlot != currentSlot && bestSlot != -1) {
            previousSlot = currentSlot;
            inventory.method_61496(bestSlot);
        }
    }
}

