/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.qsBackup;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import me.rockyhawk.qsBackup.QuickSave;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BackupHandler {
    private final QuickSave plugin;
    private int autoBackupCounter = 0;
    private BukkitTask autoBackup;
    private boolean isBackupRunning = false;

    public BackupHandler(QuickSave plugin) {
        this.plugin = plugin;
    }

    public void callRunnable() {
        if (this.autoBackup != null && this.isBackupRunning) {
            this.autoBackup.cancel();
            this.isBackupRunning = false;
        }
        if (!this.plugin.config.getBoolean("autoBackup")) {
            return;
        }
        int interval = this.plugin.config.getInt("backupInterval");
        if (interval <= 0) {
            interval = 1;
        }
        int intervalInTicks = interval * 60 * 20;
        this.autoBackup = new BukkitRunnable(){

            public void run() {
                BackupHandler.this.autoBackupCounter = BackupHandler.this.autoBackupCounter >= BackupHandler.this.plugin.config.getStringList("backupWorlds").size() - 1 ? 0 : ++BackupHandler.this.autoBackupCounter;
                ArrayList<String> backupWorlds = new ArrayList<String>();
                if (!BackupHandler.this.plugin.config.getBoolean("asyncBackup")) {
                    backupWorlds.addAll(BackupHandler.this.plugin.config.getStringList("backupWorlds"));
                } else {
                    backupWorlds.add((String)BackupHandler.this.plugin.config.getStringList("backupWorlds").get(BackupHandler.this.autoBackupCounter));
                }
                Bukkit.getConsoleSender().sendMessage(BackupHandler.this.plugin.colorize(BackupHandler.this.plugin.tag + BackupHandler.this.plugin.config.getString("saving")));
                BackupHandler.this.createNewBackup(backupWorlds);
            }
        }.runTaskTimer((Plugin)this.plugin, this.plugin.config.getBoolean("asyncBackup") ? (long)(intervalInTicks / this.plugin.config.getStringList("backupWorlds").size()) : (long)intervalInTicks, this.plugin.config.getBoolean("asyncBackup") ? (long)(intervalInTicks / this.plugin.config.getStringList("backupWorlds").size()) : (long)intervalInTicks);
        this.isBackupRunning = true;
    }

    public void createNewBackup(List<String> backupWorlds) {
        File saveFolder = this.plugin.saveFolder;
        saveFolder.mkdir();
        File rootServerFolder = new File(this.plugin.getServer().getWorldContainer().getPath());
        String strDate = new SimpleDateFormat("dd-MMM-yyyy HH-mm-ss").format(Calendar.getInstance().getTime());
        for (String worldName : backupWorlds) {
            new File(saveFolder.getAbsolutePath() + File.separator + worldName).mkdir();
            File worldToBackup = new File(rootServerFolder.getAbsolutePath() + File.separator + worldName);
            if (!worldToBackup.exists()) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.colorize(this.plugin.tag + this.plugin.config.getString("noWorld")));
                continue;
            }
            World world = Bukkit.getWorld((String)worldName);
            this.plugin.zipper.zip(world, worldToBackup, saveFolder.getAbsolutePath() + File.separator + worldName + File.separator + strDate + ".zip");
        }
    }

    public void cancelBackup() {
        if (this.autoBackup != null && this.isBackupRunning) {
            this.autoBackup.cancel();
            this.isBackupRunning = false;
        }
    }

    public boolean isRunning() {
        return this.isBackupRunning;
    }
}

