/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.qsBackup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import me.rockyhawk.qsBackup.BackupHandler;
import me.rockyhawk.qsBackup.commands.QuickSaveCommand;
import me.rockyhawk.qsBackup.commands.QuickSaveTabComplete;
import me.rockyhawk.qsBackup.filehandler.OldBackupRemoval;
import me.rockyhawk.qsBackup.filehandler.WorldZipper;
import me.rockyhawk.qsBackup.webserver.WebServer;
import me.rockyhawk.quicksave.bstats.bukkit.Metrics;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CharSequenceReader;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class QuickSave
extends JavaPlugin {
    public YamlConfiguration config;
    public File saveFolder;
    public HashSet<String> pluginStatus = new HashSet();
    public WorldZipper zipper = new WorldZipper(this);
    public OldBackupRemoval oldBackup = new OldBackupRemoval(this);
    public String tag;
    public BackupHandler backupHandler;
    public WebServer webServer;

    public void onEnable() {
        Bukkit.getConsoleSender().sendMessage("[QuickSave] RockyHawk's QuickSave v" + this.getDescription().getVersion() + " Plugin Loading...");
        this.config = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder() + File.separator + "config.yml"));
        this.getCommand("quicksave").setTabCompleter((TabCompleter)new QuickSaveTabComplete(this));
        this.getCommand("quicksave").setExecutor((CommandExecutor)new QuickSaveCommand(this));
        File configFile = new File(this.getDataFolder() + File.separator + "config.yml");
        if (!configFile.exists()) {
            try {
                configFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.getResource("config.yml")));
                configFileConfiguration.save(configFile);
                this.config = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder() + File.separator + "config.yml"));
            }
            catch (IOException var11) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[QuickSave] WARNING: Could not save the config file!");
            }
        } else {
            try {
                configFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.getResource("config.yml")));
                this.config.addDefaults((Configuration)configFileConfiguration);
                this.config.options().copyDefaults(true);
                this.config.save(new File(this.getDataFolder() + File.separator + "config.yml"));
            }
            catch (IOException var10) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[QuickSave] WARNING: Could not save the config file!");
            }
        }
        String backupPath = this.config.getString("backupLocation");
        this.saveFolder = new File(backupPath.toLowerCase().contains("p") ? this.getDataFolder() : new File("."), "backups");
        this.tag = this.config.getString("tag") + " ";
        try {
            new Metrics(this, 6727);
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[QuickSave] Could not start bStats instance, ignoring...");
        }
        Bukkit.getConsoleSender().sendMessage(ChatColor.WHITE + "[QuickSave] RockyHawk's QuickSave v" + this.getDescription().getVersion() + " Plugin Loaded!");
        this.backupHandler = new BackupHandler(this);
        this.backupHandler.callRunnable();
        if (this.config.getBoolean("webInterface")) {
            this.webServer = new WebServer(this);
            this.webServer.start();
        }
    }

    public void onDisable() {
        if (this.backupHandler != null) {
            this.backupHandler.cancelBackup();
        }
    }

    public void reloadPlugin() {
        this.config = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder() + File.separator + "config.yml"));
        this.updateSaveFolder();
        this.tag = this.config.getString("tag") + " ";
        this.backupHandler.callRunnable();
        this.getServer().getConsoleSender().sendMessage(this.colorize(this.tag + this.config.getString("reload")));
    }

    private void updateSaveFolder() {
        String backupLocation = this.config.getString("backupLocation");
        String backupPath = this.config.getString("backupPath");
        switch (backupLocation.toLowerCase()) {
            case "root": {
                this.saveFolder = new File("./backups");
                break;
            }
            case "custom": {
                try {
                    this.saveFolder = new File(backupPath, "backups").getCanonicalFile();
                    if (this.saveFolder.exists()) break;
                    this.saveFolder.mkdirs();
                }
                catch (IOException e) {
                    this.saveFolder = new File(this.getDataFolder(), "backups");
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[QuickSave] Custom backup path could not be used.");
                }
                break;
            }
            default: {
                this.saveFolder = new File(this.getDataFolder(), "backups");
            }
        }
    }

    public String colorize(String input) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    public Reader getReaderFromStream(InputStream initialStream) throws IOException {
        byte[] buffer = IOUtils.toByteArray(initialStream);
        return new CharSequenceReader(new String(buffer));
    }
}

