/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.qsBackup.commands;

import java.util.ArrayList;
import me.rockyhawk.qsBackup.QuickSave;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class QuickSaveCommand
implements CommandExecutor {
    QuickSave plugin;

    public QuickSaveCommand(QuickSave pl) {
        this.plugin = pl;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length < 1) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "version": {
                this.handleVersion(sender);
                break;
            }
            case "backup": {
                this.handleBackup(sender, args);
                break;
            }
            case "status": {
                this.handleStatus(sender);
                break;
            }
            default: {
                this.sendHelpMessage(sender);
            }
        }
        return true;
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("quicksave.admin.reload")) {
            this.sendNoPermissionMessage(sender);
            return;
        }
        this.plugin.reloadPlugin();
    }

    private void handleVersion(CommandSender sender) {
        if (!sender.hasPermission("quicksave.version")) {
            this.sendNoPermissionMessage(sender);
            return;
        }
        sender.sendMessage(this.plugin.colorize(this.plugin.tag));
        sender.sendMessage(ChatColor.GREEN + "Version " + ChatColor.GRAY + this.plugin.getDescription().getVersion());
        sender.sendMessage(ChatColor.GREEN + "Developer " + ChatColor.GRAY + "RockyHawk");
        sender.sendMessage(ChatColor.GREEN + "Command " + ChatColor.GRAY + "/qs");
    }

    private void handleBackup(CommandSender sender, String[] args) {
        if (!sender.hasPermission("quicksave.admin.backup")) {
            this.sendNoPermissionMessage(sender);
            return;
        }
        ArrayList<String> backupWorlds = new ArrayList<String>();
        if (args.length > 1) {
            if (!this.plugin.config.getStringList("config.backupWorlds").contains(args[1])) {
                sender.sendMessage(this.plugin.colorize(this.plugin.tag + this.plugin.config.getString("noWorld")));
                return;
            }
            if (this.plugin.pluginStatus.contains(args[1])) {
                sender.sendMessage(this.plugin.colorize(this.plugin.tag + this.plugin.config.getString("alreadyBackup") + ChatColor.WHITE + " " + args[1]));
                return;
            }
            backupWorlds.add(args[1]);
        } else {
            backupWorlds.addAll(this.plugin.config.getStringList("backupWorlds"));
        }
        sender.sendMessage(this.plugin.colorize(this.plugin.tag + this.plugin.config.getString("saving")));
        this.plugin.backupHandler.createNewBackup(backupWorlds);
    }

    private void handleStatus(CommandSender sender) {
        if (!sender.hasPermission("quicksave.admin.status")) {
            this.sendNoPermissionMessage(sender);
            return;
        }
        if (this.plugin.pluginStatus.isEmpty()) {
            sender.sendMessage(this.plugin.colorize(this.plugin.tag + this.plugin.config.getString("noStatus")));
        } else if (this.plugin.pluginStatus.size() == 1) {
            sender.sendMessage(this.plugin.colorize(this.plugin.tag + this.plugin.config.getString("status") + ChatColor.WHITE + " " + this.plugin.pluginStatus.stream().findFirst().orElse("null")));
        } else {
            sender.sendMessage(this.plugin.colorize(this.plugin.tag + this.plugin.config.getString("status")));
            for (String world : this.plugin.pluginStatus) {
                sender.sendMessage(ChatColor.WHITE + "- " + world);
            }
        }
    }

    private void sendHelpMessage(CommandSender sender) {
        if (!sender.hasPermission("quicksave.help")) {
            this.sendNoPermissionMessage(sender);
            return;
        }
        sender.sendMessage(this.plugin.colorize(this.plugin.tag + ChatColor.GREEN + "Commands:"));
        if (sender.hasPermission("quicksave.admin.reload")) {
            sender.sendMessage(ChatColor.GREEN + "/qs reload " + ChatColor.WHITE + "Reloads plugin config.");
        }
        if (sender.hasPermission("quicksave.admin.backup")) {
            sender.sendMessage(ChatColor.GREEN + "/qs backup " + ChatColor.WHITE + "Creates a new backup for all worlds.");
            sender.sendMessage(ChatColor.GREEN + "/qs backup [world name] " + ChatColor.WHITE + "Creates a new backup for one world.");
        }
        if (sender.hasPermission("quicksave.admin.status")) {
            sender.sendMessage(ChatColor.GREEN + "/qs status " + ChatColor.WHITE + "Check if the plugin is currently backing up any worlds.");
        }
        if (sender.hasPermission("quicksave.version")) {
            sender.sendMessage(ChatColor.GREEN + "/qs version " + ChatColor.WHITE + "Display the current version");
        }
    }

    private void sendNoPermissionMessage(CommandSender sender) {
        sender.sendMessage(this.plugin.colorize(this.plugin.tag + this.plugin.config.getString("format.perms")));
    }
}

