/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.qsBackup.filehandler;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.util.function.Predicate;
import me.rockyhawk.qsBackup.QuickSave;
import org.bukkit.ChatColor;

public class OldBackupRemoval {
    QuickSave plugin;
    private static final long BYTES_PER_MEGABYTE = 0x100000L;

    public OldBackupRemoval(QuickSave pl) {
        this.plugin = pl;
    }

    public void checkWorldForOldBackups(File directory) {
        if (this.plugin.config.getBoolean("amountLimit")) {
            this.deleteFiles(directory, dir -> dir.listFiles() != null && dir.listFiles().length > this.plugin.config.getInt("amountLimitMax"));
        }
        if (this.plugin.config.getBoolean("sizeLimit")) {
            this.deleteFiles(directory, dir -> this.getFileFolderSize((File)dir) > (long)this.plugin.config.getInt("sizeLimitMax") * 0x100000L);
        }
    }

    private void deleteFiles(File directory, Predicate<File> shouldDelete) {
        while (shouldDelete.test(directory)) {
            File oldestFile = this.getOldestFile(directory);
            if (oldestFile == null) continue;
            try {
                Files.delete(oldestFile.toPath());
            }
            catch (FileSystemException e) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.colorize(this.plugin.tag + ChatColor.RED + "Could not delete file " + oldestFile.getName() + " because it's in use by another process."));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File getOldestFile(File directory) {
        long oldestDate = Long.MAX_VALUE;
        File oldestFile = null;
        for (File ftempFile : directory.listFiles()) {
            if (ftempFile.lastModified() >= oldestDate) continue;
            oldestDate = ftempFile.lastModified();
            oldestFile = ftempFile;
        }
        return oldestFile;
    }

    private long getFileFolderSize(File dir) {
        long size = 0L;
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                size += file.length();
                continue;
            }
            size += this.getFileFolderSize(file);
        }
        return size;
    }
}

