/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.qsBackup.filehandler;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import me.rockyhawk.qsBackup.QuickSave;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WorldZipper {
    QuickSave plugin;

    public WorldZipper(QuickSave pl) {
        this.plugin = pl;
    }

    public void zip(final World world, final File worldDirectory, final String destZipFile) {
        if (this.plugin.pluginStatus.contains(world.getName())) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.colorize(this.plugin.tag + this.plugin.config.getString("alreadyBackup") + ChatColor.WHITE + " " + worldDirectory.getName()));
            return;
        }
        new BukkitRunnable(){

            public void run() {
                WorldZipper.this.plugin.pluginStatus.add(world.getName());
                world.setAutoSave(false);
                world.save();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.saveData();
                }
                new Thread(() -> {
                    try {
                        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destZipFile));){
                            WorldZipper.this.zipDirectory(worldDirectory, worldDirectory.getName(), zos);
                        }
                        WorldZipper.this.plugin.getServer().getConsoleSender().sendMessage(WorldZipper.this.plugin.colorize(WorldZipper.this.plugin.tag + WorldZipper.this.plugin.config.getString("finishedBackup") + ChatColor.WHITE + " " + worldDirectory.getName()));
                        WorldZipper.this.plugin.oldBackup.checkWorldForOldBackups(new File(WorldZipper.this.plugin.saveFolder.getAbsolutePath() + File.separator + worldDirectory.getName()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        WorldZipper.this.plugin.getServer().getConsoleSender().sendMessage(WorldZipper.this.plugin.colorize(WorldZipper.this.plugin.tag + WorldZipper.this.plugin.config.getString("failedBackup") + ChatColor.WHITE + " " + worldDirectory.getName()));
                    }
                    Bukkit.getScheduler().runTask((Plugin)WorldZipper.this.plugin, () -> world.setAutoSave(true));
                    WorldZipper.this.plugin.pluginStatus.remove(world.getName());
                }).start();
            }
        }.runTask((Plugin)this.plugin);
    }

    private void zipDirectory(File folder, String parentFolder, ZipOutputStream zos) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                this.zipDirectory(file, parentFolder + "/" + file.getName(), zos);
                continue;
            }
            try {
                zos.putNextEntry(new ZipEntry(parentFolder + "/" + file.getName()));
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
                    int read;
                    int BUFFER_SIZE = 4096;
                    byte[] bytesIn = new byte[BUFFER_SIZE];
                    while ((read = bis.read(bytesIn)) != -1) {
                        zos.write(bytesIn, 0, read);
                    }
                }
                zos.closeEntry();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

