/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.qsBackup.webserver;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import me.rockyhawk.qsBackup.QuickSave;

public class BackupServlet
extends HttpServlet {
    private final QuickSave plugin;

    public BackupServlet(QuickSave plugin) {
        this.plugin = plugin;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JsonObject response = new JsonObject();
        JsonArray backupFilesJsonArray = new JsonArray();
        for (String world : this.plugin.config.getStringList("backupWorlds")) {
            File[] backupFiles;
            File backupDir = new File(this.plugin.saveFolder, world);
            if (!backupDir.exists() || !backupDir.isDirectory() || (backupFiles = backupDir.listFiles()) == null) continue;
            for (File backupFile : backupFiles) {
                if (!backupFile.isFile()) continue;
                JsonObject backupFileJson = new JsonObject();
                String fileName = backupFile.getName();
                long fileSize = backupFile.length();
                String worldName = world;
                backupFileJson.add("world", (JsonElement)new JsonPrimitive(worldName));
                backupFileJson.add("fileName", (JsonElement)new JsonPrimitive(fileName));
                backupFileJson.add("size", (JsonElement)new JsonPrimitive((Number)fileSize));
                backupFilesJsonArray.add((JsonElement)backupFileJson);
            }
        }
        response.add("backupFiles", (JsonElement)backupFilesJsonArray);
        resp.setContentType("application/json");
        resp.getWriter().println(response);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ArrayList<String> backupWorlds = new ArrayList<String>();
        String path = req.getRequestURI();
        if (path.equals("/api/backup")) {
            backupWorlds.addAll(this.plugin.config.getStringList("backupWorlds"));
        } else if (path.startsWith("/api/backup/")) {
            String world = path.substring(path.lastIndexOf("/") + 1);
            backupWorlds.add(world);
        }
        this.plugin.backupHandler.createNewBackup(backupWorlds);
    }
}

