/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.qsBackup.webserver;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.rockyhawk.qsBackup.QuickSave;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigServlet
extends HttpServlet {
    private final QuickSave plugin;

    public ConfigServlet(QuickSave plugin) {
        this.plugin = plugin;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JsonObject response = new JsonObject();
        this.addConfigValuesToResponse(response, this.plugin.config.getValues(true));
        resp.setContentType("application/json");
        resp.getWriter().println(response);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String line;
        StringBuilder body = new StringBuilder();
        BufferedReader reader = req.getReader();
        while ((line = reader.readLine()) != null) {
            body.append(line);
        }
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse(body.toString()).getAsJsonObject();
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonArray()) {
                ArrayList<String> list = new ArrayList<String>();
                for (JsonElement item : value.getAsJsonArray()) {
                    list.add(item.getAsString());
                }
                this.plugin.config.set(key, list);
                continue;
            }
            if (!value.isJsonPrimitive()) continue;
            JsonPrimitive primitiveValue = value.getAsJsonPrimitive();
            if (primitiveValue.isBoolean()) {
                this.plugin.config.set(key, (Object)primitiveValue.getAsBoolean());
                continue;
            }
            if (primitiveValue.isNumber()) {
                Number number = primitiveValue.getAsNumber();
                if (number instanceof Integer) {
                    this.plugin.config.set(key, (Object)number.intValue());
                    continue;
                }
                if (number instanceof Long) {
                    this.plugin.config.set(key, (Object)number.longValue());
                    continue;
                }
                this.plugin.config.set(key, (Object)number.doubleValue());
                continue;
            }
            this.plugin.config.set(key, (Object)primitiveValue.getAsString());
        }
        this.saveConfig();
        this.plugin.reloadPlugin();
        JsonObject response = new JsonObject();
        response.addProperty("status", "saved");
        resp.setContentType("application/json");
        resp.getWriter().println(response);
    }

    private void saveConfig() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        YamlConfiguration configYaml = YamlConfiguration.loadConfiguration((File)configFile);
        for (String key : this.plugin.config.getKeys(true)) {
            Object value = this.plugin.config.get(key);
            this.saveValueToConfig(configYaml, key, value);
        }
        try {
            configYaml.save(configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveValueToConfig(YamlConfiguration configYaml, String key, Object value) {
        if (value instanceof List) {
            configYaml.set(key, value);
        } else {
            configYaml.set(key, value);
        }
    }

    private JsonArray toJsonArray(List<String> list) {
        JsonArray array = new JsonArray();
        for (String item : list) {
            array.add((JsonElement)new JsonPrimitive(item));
        }
        return array;
    }

    private void addConfigValuesToResponse(JsonObject response, Map<String, Object> configValues) {
        for (Map.Entry<String, Object> entry : configValues.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                response.add(key, (JsonElement)this.toJsonArray((List)value));
                continue;
            }
            if (value instanceof Map) {
                JsonObject subObject = new JsonObject();
                this.addConfigValuesToResponse(subObject, (Map)value);
                response.add(key, (JsonElement)subObject);
                continue;
            }
            response.addProperty(key, value.toString());
        }
    }
}

