/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.qsBackup.webserver;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import me.rockyhawk.qsBackup.QuickSave;
import org.bukkit.Bukkit;

public class PluginServlet
extends HttpServlet {
    private final QuickSave plugin;

    public PluginServlet(QuickSave plugin) {
        this.plugin = plugin;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JsonObject response = new JsonObject();
        response.addProperty("serverVersion", Bukkit.getVersion());
        response.addProperty("backupsRunning", (Number)this.plugin.pluginStatus.size());
        response.addProperty("autoBackupStatus", Boolean.valueOf(this.plugin.backupHandler.isRunning()));
        response.addProperty("autoBackupAsync", Boolean.valueOf(this.plugin.config.getBoolean("asyncBackup")));
        JsonArray backupWorldsJsonArray = new JsonArray();
        for (String world : this.plugin.config.getStringList("backupWorlds")) {
            JsonPrimitive worldJsonElement = new JsonPrimitive(world);
            backupWorldsJsonArray.add((JsonElement)worldJsonElement);
        }
        response.add("backupWorlds", (JsonElement)backupWorldsJsonArray);
        resp.setContentType("application/json");
        resp.getWriter().println(response);
    }
}

