/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.qsBackup.webserver;

import me.rockyhawk.qsBackup.QuickSave;
import me.rockyhawk.qsBackup.webserver.BackupServlet;
import me.rockyhawk.qsBackup.webserver.ConfigServlet;
import me.rockyhawk.qsBackup.webserver.PluginServlet;
import me.rockyhawk.quicksave.jetty.server.Connector;
import me.rockyhawk.quicksave.jetty.server.Server;
import me.rockyhawk.quicksave.jetty.server.ServerConnector;
import me.rockyhawk.quicksave.jetty.servlet.DefaultServlet;
import me.rockyhawk.quicksave.jetty.servlet.ServletContextHandler;
import me.rockyhawk.quicksave.jetty.servlet.ServletHolder;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class WebServer {
    private final QuickSave plugin;
    private Server server;

    public WebServer(QuickSave plugin) {
        this.plugin = plugin;
    }

    public void start() {
        this.server = new Server();
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost("127.0.0.1");
        connector.setPort(this.plugin.config.getInt("webPort"));
        this.server.setConnectors(new Connector[]{connector});
        try {
            ServletHolder holder = new ServletHolder("default", DefaultServlet.class);
            holder.setInitParameter("resourceBase", WebServer.class.getClassLoader().getResource("static").toExternalForm());
            holder.setInitParameter("dirAllowed", "false");
            context.addServlet(holder, "/");
            context.addServlet(new ServletHolder(new PluginServlet(this.plugin)), "/api");
            context.addServlet(new ServletHolder(new ConfigServlet(this.plugin)), "/api/config");
            context.addServlet(new ServletHolder(new BackupServlet(this.plugin)), "/api/backup/*");
            this.server.setHandler(context);
            this.server.start();
            Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[QuickSave] Web server started on port 8080");
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[QuickSave] Failed to start web server: " + e.getMessage());
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
                Bukkit.getConsoleSender().sendMessage(ChatColor.WHITE + "[QuickSave] Web server stopped.");
            }
            catch (Exception e) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[QuickSave] Failed to stop web server: " + e.getMessage());
            }
        }
    }

    public boolean isRunning() {
        return this.server != null && this.server.isStarted();
    }
}

