/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.quicksave.jetty.server;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import me.rockyhawk.quicksave.jetty.io.ByteBufferPool;
import me.rockyhawk.quicksave.jetty.io.ManagedSelector;
import me.rockyhawk.quicksave.jetty.io.NetworkTrafficListener;
import me.rockyhawk.quicksave.jetty.io.NetworkTrafficSocketChannelEndPoint;
import me.rockyhawk.quicksave.jetty.io.SocketChannelEndPoint;
import me.rockyhawk.quicksave.jetty.server.ConnectionFactory;
import me.rockyhawk.quicksave.jetty.server.HttpConnectionFactory;
import me.rockyhawk.quicksave.jetty.server.Server;
import me.rockyhawk.quicksave.jetty.server.ServerConnector;
import me.rockyhawk.quicksave.jetty.util.ssl.SslContextFactory;
import me.rockyhawk.quicksave.jetty.util.thread.Scheduler;

public class NetworkTrafficServerConnector
extends ServerConnector {
    private volatile NetworkTrafficListener listener;

    public NetworkTrafficServerConnector(Server server) {
        this(server, null, null, null, 0, 0, new HttpConnectionFactory());
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory, SslContextFactory.Server sslContextFactory) {
        super(server, sslContextFactory, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory) {
        super(server, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, int selectors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, pool, acceptors, selectors, factories);
    }

    public NetworkTrafficServerConnector(Server server, SslContextFactory.Server sslContextFactory) {
        super(server, sslContextFactory);
    }

    public void setNetworkTrafficListener(NetworkTrafficListener listener) {
        this.listener = listener;
    }

    public NetworkTrafficListener getNetworkTrafficListener() {
        return this.listener;
    }

    @Override
    protected SocketChannelEndPoint newEndPoint(SocketChannel channel, ManagedSelector selectSet, SelectionKey key) {
        return new NetworkTrafficSocketChannelEndPoint(channel, selectSet, key, this.getScheduler(), this.getIdleTimeout(), this.getNetworkTrafficListener());
    }
}

