package org.sophia.slate_work.GUI;

import org.sophia.slate_work.blocks.CraftingLoci;
import org.sophia.slate_work.blocks.entities.CraftingLociEntity;
import org.sophia.slate_work.misc.DumbDumbInv;

import static org.sophia.slate_work.Slate_work.GHOST_3X3_SCREEN;

import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3956;

public class Ghost3x3ScreenHandler extends class_1703 {
    private final class_1263 inventory;
    private final class_1937 world;

    public Ghost3x3ScreenHandler(int syncId, class_1661 inventory, class_1661 playerInventory, class_1263 blockEntity) {
        this(syncId, playerInventory, blockEntity);
    }

    public Ghost3x3ScreenHandler(int id, class_1661 playerInventory, class_2540 packetByteBuf) {
        this(id,playerInventory, playerInventory,
                new DumbDumbInv((CraftingLociEntity) playerInventory.field_7546.method_37908().method_8321(packetByteBuf.method_10811()))
        );
    }

    public Ghost3x3ScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory) {
        super(GHOST_3X3_SCREEN, syncId);
        method_17359(inventory, 9);
        this.inventory = inventory;
        this.world = playerInventory.field_7546.method_37908();
        inventory.method_5435(playerInventory.field_7546);

        this.method_7621(new GhostSlotOutput(inventory,9,138,32,this));

        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 3; j++) {
                this.method_7621(new GhostSlot(inventory, j + i * 3, 62 + j * 18, 14 + i * 18));
            }
        }
        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 9; j++) {
                this.method_7621(new class_1735(playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int i = 0; i < 9; i++) {
            this.method_7621(new class_1735(playerInventory, i, 8 + i * 18, 142));
        }
    }

    @Override
    public void method_7609(class_1263 inventory) {
        Ghost3x3ScreenHandler.updateRecipe(this.world,inventory);
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        return class_1799.field_8037;
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.inventory.method_5432(player);
    }

    @Override
    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if ((actionType != class_1713.field_7796 && actionType != class_1713.field_7790 && actionType != class_1713.field_7794) || button == -1) return;

        if (slotIndex < 10 && slotIndex > 0){ // Ok cool, we are working in the Ghost Screen
            // If we are in creative mode, copy the selected items
            if (actionType == class_1713.field_7796 && player.method_31549().field_7477 && this.method_34255().method_7960()) {
                class_1735 slot3 = this.field_7761.get(slotIndex);
                if (slot3.method_7681()) {
                    class_1799 itemStack2 = slot3.method_7677();
                    this.method_34254(itemStack2.method_46651(itemStack2.method_7914()));
                }
            //else, just act as normal
            } else {
                var copy = this.method_34255().method_7972();
                copy.method_7939(1);
                this.inventory.method_5447(slotIndex-1,copy);
                Ghost3x3ScreenHandler.updateRecipe(this.world,inventory);
            }
        } else super.method_7593(slotIndex, button, actionType, player);
    }

    public static void updateRecipe(class_1937 world, class_1263 inventory){
        if (inventory instanceof DumbDumbInv ghostCrafting){
            var container = new class_1715(new CraftingLoci.AutocraftingMenu(), 3, 3);
            for (int i = 0; i < 9; i++){
                container.method_5447(i,ghostCrafting.method_5438(i));
            }

            var recipeOpt = world.method_8433().method_8132(class_3956.field_17545, container ,world);
            if (recipeOpt.isEmpty()){
                ghostCrafting.method_5447(9,class_1799.field_8037);
                return;
            }

            var outputItem = recipeOpt.get().method_8116(container,world.method_30349());
            ghostCrafting.method_5447(9, outputItem);
        }
    }
}
