package org.sophia.slate_work;

import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import com.google.common.collect.ImmutableMap;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class SlateWorkMixinPlugin implements IMixinConfigPlugin {
    private static final Supplier<Boolean> TRUE = () -> true;
    private static final Map<String, Supplier<Boolean>> CONDITIONS = ImmutableMap.of(
            "org.sophia.slate_work.mixins.MixinDirtyDirtyHack", () -> {
                try {
                    Class<?> clazz = Class.forName("at.petrak.hexcasting.api.casting.circles.CircleExecutionState");
                    Field field = clazz.getDeclaredField("TAG_REACHED_NUMBER");
                    field.get(null);
                    return false;
                } catch (ClassNotFoundException | NoSuchFieldException | IllegalAccessException e) {
                    return true;
                }
            }
    );
    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        //return CONDITIONS.getOrDefault(mixinClassName, TRUE).get();
        return true;
    }

    @Override
    public void onLoad(String mixinPackage) {

    }

    @Override
    public String getRefMapperConfig() {
        return "";
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {

    }

    @Override
    public List<String> getMixins() {
        return List.of();
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {

    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {

    }
}
