package org.sophia.slate_work;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.EntityIota;
import at.petrak.hexcasting.common.lib.HexSounds;
import com.mojang.serialization.Codec;
import miyucomics.hexpose.iotas.TextIota;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.sophia.slate_work.GUI.Ghost3x3ScreenHandler;
import org.sophia.slate_work.GUI.HotbarLociScreenHandler;
import org.sophia.slate_work.casting.CircleAmbitChanges;
import org.sophia.slate_work.compat.SlateWorksIoticBlocks;
import org.sophia.slate_work.compat.SlateWorksTrinkets;
import org.sophia.slate_work.misc.ChatHelper;
import org.sophia.slate_work.misc.KnownBroadcasters;
import org.sophia.slate_work.registries.BlockRegistry;
import org.sophia.slate_work.registries.FrameRegistry;
import org.sophia.slate_work.registries.PatternRegistry;
import org.sophia.slate_work.registries.AttributeRegistry;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

@SuppressWarnings("UnstableApiUsage")
public class Slate_work implements ModInitializer {
    public static final String MOD_ID = "slate_work";
    public static final Logger LOGGER = Logger.getLogger("Slate Works");
    public static final AttachmentType<List<class_2338>> chunk_listeners = AttachmentRegistry.<List<class_2338>>builder()
            .initializer(ArrayList::new)
            .copyOnDeath().persistent(Codec.list(class_2338.field_25064))
            .buildAndRegister(new class_2960(MOD_ID, "listening_attachment"));

    public static class_3917<Ghost3x3ScreenHandler> GHOST_3X3_SCREEN = class_2378.method_10230(class_7923.field_41187,
            new class_2960(MOD_ID,"ghost3x3screen"),
            new ExtendedScreenHandlerType<>(Ghost3x3ScreenHandler::new));
    public static class_3917<HotbarLociScreenHandler> HOTBAR_LOCI_SCREEN = class_2378.method_10230(class_7923.field_41187,
            new class_2960(MOD_ID, "hotbar_loci_screen"),
            new ExtendedScreenHandlerType<>(HotbarLociScreenHandler::new));

    @Override
    public void onInitialize() {
        BlockRegistry.init();
        PatternRegistry.init();
        FrameRegistry.init();
        AttributeRegistry.init();
        ItemStorage.SIDED.registerSelf(BlockRegistry.STORAGE_LOCI_ENTITY);
        ItemStorage.SIDED.registerSelf(BlockRegistry.HOTBAR_LOCI_ENTITY);

        CastingEnvironment.addCreateEventListener( (a,b) -> a.addExtension(new CircleAmbitChanges(a)));

        ServerLifecycleEvents.SERVER_STOPPING.register(new ClearBroadcasters());
            ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) ->{
                    var z = ChatHelper.getHelper().willBlock(message.method_44862(), sender);
                    if (z.entity().isPresent()){
                        var entity = z.entity().get();
                        String string = z.string().substring(entity.getString().length()).stripLeading();
                        if (string.isBlank()) string = " ";
                        entity.setIotas(new EntityIota(sender), new TextIota(class_2561.method_43470(string)));
                        entity.startExecution(sender);
                        entity.sync();
                    }
                    if (!z.failed() && z.blocked()) {
                        if (z.item() && z.entity().isEmpty()) sender.method_17356(HexSounds.FLIGHT_FINISH, class_3419.field_15248, 1f, 1.5f);
                        else sender.method_17356(HexSounds.READ_LORE_FRAGMENT, class_3419.field_15248, 1f, 2f);
                    } else if (z.failed() && z.whispering().isPresent() && z.entity().isEmpty() && z.blocked()) {
                        var stack = z.whispering().get();
                        sender.method_17356(HexSounds.CAST_FAILURE, class_3419.field_15248, 1f, 1f);
                        stack.method_7983("cords");
                        stack.method_7983("string");
                    }
                    return !z.blocked();
            });


        if (FabricLoader.getInstance().isModLoaded("ioticblocks")) {
            SlateWorksIoticBlocks.init();
        }
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            SlateWorksTrinkets.init();
            ChatHelper.getHelper().setTRINKETS(true);
        }
    }

    private static class ClearBroadcasters implements ServerLifecycleEvents.ServerStopping {
        @Override
        public void onServerStopping(MinecraftServer server) {
            KnownBroadcasters.INSTANCE.clear();
        }
    }
}