package org.sophia.slate_work.blocks;

import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.misc.MediaConstants;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import org.sophia.slate_work.casting.mishap.MishapSpellCircleMedia;

public class AcceleratorLoci extends AbstractSlate {
    public static final int accel = 13;
    private static final double THICKNESS = 6;
    private static final class_265 DOWN_AB = class_259.method_1084(
            class_2248.method_9541(0, 0, 0, 16, THICKNESS, 16),
            class_2248.method_9541(1,1,1,15,11,15));
    private static final class_265 UP_AB = class_259.method_1084(
            class_2248.method_9541(0, 16 - THICKNESS, 0, 16, 16, 16),
            class_2248.method_9541(1,5,1,15,15,15));
    private static final class_265 EAST_AB = class_259.method_1084(
            class_2248.method_9541(0, 0, 0, THICKNESS, 16, 16),
            class_2248.method_9541(5,1,1,11,15,15));
    private static final class_265 WEST_AB = class_259.method_1084(
            class_2248.method_9541(16 - THICKNESS, 0, 0, 16, 16, 16),
            class_2248.method_9541(5,1,1,15,15,15));
    private static final class_265 NORTH_AB = class_259.method_1084(
            class_2248.method_9541(0, 0, 16 - THICKNESS, 16, 16, 16),
            class_2248.method_9541(1,1,5,15,15,15));
    private static final class_265 SOUTH_AB = class_259.method_1084(
            class_2248.method_9541(0, 0, 0, 16, 16, THICKNESS),
            class_2248.method_9541(1,1,1,15,15,11));

    public AcceleratorLoci(class_2251 p_49795_) {
        super(p_49795_);
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return switch (pState.method_11654(FACING)){
            case field_11043 -> NORTH_AB;
            case field_11035 -> SOUTH_AB;
            case field_11039 -> WEST_AB;
            case field_11034 -> EAST_AB;
            case field_11036 -> DOWN_AB;
            case field_11033 -> UP_AB;
        };
    }

    @Override
    public ControlFlow acceptControlFlow(CastingImage imageIn, CircleCastEnv env, class_2350 enterDir, class_2338 pos, class_2680 bs, class_3218 world) {
        var data = imageIn.getUserData().method_10553();
        var speed = data.method_10550("accel_left");


        long cost = (MediaConstants.DUST_UNIT*2)*Math.max(1, (speed*speed)/accel);
        var extracted = env.extractMedia(cost, false);
        if (0L != extracted) {
            this.fakeThrowMishap(
                    pos, bs, imageIn, env,
                    new MishapSpellCircleMedia(extracted, pos)
            );
            return new ControlFlow.Stop();
        }

        data.method_10569("accel_left", speed+accel);
        var exitDirsSet = this.possibleExitDirections(pos, bs, world);
        exitDirsSet.remove(enterDir.method_10153());
        var exitDirs = exitDirsSet.stream().map((dir) -> this.exitPositionFromDirection(pos, dir)).toList();
        return new ControlFlow.Continue(imageIn.copy(imageIn.getStack(),imageIn.getParenCount(),
                imageIn.getParenthesized(),imageIn.getEscapeNext(),imageIn.getOpsConsumed(), data), exitDirs);
    }
}
