package org.sophia.slate_work.blocks;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.mishaps.MishapOthersName;
import org.jetbrains.annotations.Nullable;
import org.sophia.slate_work.blocks.entities.BroadcasterLociEntity;
import org.sophia.slate_work.casting.mishap.MishapSpellCircleInvalidIota;
import org.sophia.slate_work.casting.mishap.MishapSpellCircleNotEnoughArgs;
import org.sophia.slate_work.misc.KnownBroadcasters;

import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;

public class BroadcasterLoci extends BlockCircleComponent implements class_2343 {
    public BroadcasterLoci(class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590(this.field_10647.method_11664().method_11657(ENERGIZED, false));
    }

    @Override
    public class_2350 normalDir(class_2338 blockPos, class_2680 blockState, class_1937 world, int i) {
        return class_2350.field_11036;
    }

    @Override
    public float particleHeight(class_2338 blockPos, class_2680 blockState, class_1937 world) {
        return 0;
    }

    @Override
    public ControlFlow acceptControlFlow(CastingImage castingImage, CircleCastEnv circleCastEnv, class_2350 direction, class_2338 blockPos, class_2680 blockState, class_3218 serverWorld) {
        if (serverWorld.method_8321(blockPos) instanceof BroadcasterLociEntity entity){
            var stack = new ArrayList<>(castingImage.getStack());

            if (stack.isEmpty()) { // Feels silly, but this is what Hex does
                this.fakeThrowMishap(
                        blockPos, blockState, castingImage, circleCastEnv,
                        new MishapSpellCircleNotEnoughArgs(1,0, blockPos));
                return new ControlFlow.Stop();
            }
            int index = stack.size() -1;
            var iota = stack.get(index);
            stack.remove(index);

            if (iota.size() > 1){ // Don't want to store "complex" iotas, like lists and Jumps
                this.fakeThrowMishap(blockPos, blockState, castingImage, circleCastEnv,
                        MishapSpellCircleInvalidIota.of(iota, 0,"simpler_iota", blockPos));
                return new ControlFlow.Stop();
            }
            var truename = MishapOthersName.getTrueNameFromDatum(iota, null);
            if (truename != null){
                this.fakeThrowMishap(blockPos, blockState, castingImage, circleCastEnv,
                        new MishapOthersName(truename));
                return new ControlFlow.Stop();
            }

            entity.setIota(iota);

            var exitDirsSet = this.possibleExitDirections(blockPos, blockState, serverWorld);
            exitDirsSet.remove(direction.method_10153());
            var exits = exitDirsSet.stream().map((dir) -> this.exitPositionFromDirection(blockPos, dir)).toList();

            return new ControlFlow.Continue(castingImage.copy(
                    stack, castingImage.getParenCount(), castingImage.getParenthesized(), castingImage.getEscapeNext(), castingImage.getOpsConsumed(), castingImage.getUserData()
            ), exits);
        }
        return new ControlFlow.Stop();
    }

    @Override
    public boolean canEnterFromDirection(class_2350 direction, class_2338 blockPos, class_2680 blockState, class_3218 serverWorld) {
        return direction != class_2350.field_11033;
    }

    @Override
    public EnumSet<class_2350> possibleExitDirections(class_2338 blockPos, class_2680 blockState, class_1937 world) {
        EnumSet<class_2350> z = EnumSet.allOf(class_2350.class);
        z.remove(class_2350.field_11036);
        return z;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_17786(
                method_9541(0,0,0,16,3,16),
                method_9541(0,3,0,4,9,4),
                method_9541(12,3,0,16,9,4),
                method_9541(0,3,12,4,9,16),
                method_9541(12,3,12,16,9,16),
                method_9541(0,9,0,16,12,16),
                method_9541(7,0,7,9,9,9)
        );
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
         if (!state.method_27852(newState.method_26204()) && world.method_8321(pos) instanceof BroadcasterLociEntity broadcaster){
            KnownBroadcasters.INSTANCE.removeBroadcaster(broadcaster);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BroadcasterLociEntity(pos, state);
    }
}
