package org.sophia.slate_work.blocks;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.casting.circles.ICircleComponent;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.iota.BooleanIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_5151;
import org.jetbrains.annotations.Nullable;
import org.sophia.slate_work.blocks.entities.CraftingLociEntity;
import org.sophia.slate_work.casting.mishap.MishapNoStorageLoci;
import org.sophia.slate_work.misc.CircleHelper;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import static at.petrak.hexcasting.common.lib.HexSounds.IMPETUS_REDSTONE_DING;

@SuppressWarnings({"deprecation", "UnstableApiUsage"})
public class CraftingLoci extends BlockCircleComponent implements class_2343, class_5151 {

    public CraftingLoci(class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590(this.field_10647.method_11664().method_11657(ENERGIZED, false));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_17786(
                // Foundation
                method_9541(0,0,0,16,2,2),
                method_9541(0,0,0,2,2,16),
                method_9541(14,0,0,16,2,16),
                method_9541(0,0,14,16,2,16),

                // Vertical bars
                method_9541(7,0,0,9,14,2),
                method_9541(7,0,14,9,14,16),
                method_9541(0,0,7,2,14,9),
                method_9541(14,0,7,16,14,9),

                // Center Cube + center bars
                method_9541(5,4,5,11,10,11),
                method_9541(0,6,7,16,8,9),
                method_9541(7,6,0,9,8,16),

                // Top slate
                method_9541(0,12,0,16,14,16)
        );
    }

    @Override
    public class_2350 normalDir(class_2338 blockPos, class_2680 blockState, class_1937 world, int i) {
        return class_2350.field_11036;
    }

    @Override
    public float particleHeight(class_2338 blockPos, class_2680 blockState, class_1937 world) {
        return 0.5f;
    }
    @Override
    public boolean canEnterFromDirection(class_2350 direction, class_2338 blockPos, class_2680 blockState, class_3218 serverWorld) {
        return direction != class_2350.field_11036;
    }

    @Override
    public EnumSet<class_2350> possibleExitDirections(class_2338 blockPos, class_2680 blockState, class_1937 world) {
        EnumSet<class_2350> z = EnumSet.allOf(class_2350.class);
        z.remove(class_2350.field_11036);
        return z;
    }

    @Override
    public ICircleComponent.ControlFlow acceptControlFlow(CastingImage castingImage, CircleCastEnv circleCastEnv, class_2350 direction, class_2338 blockPos, class_2680 blockState, class_3218 serverWorld) {
        class_2586 entity = serverWorld.method_8321(blockPos);

        if (entity instanceof CraftingLociEntity craftingLoci) {
            ArrayList<Iota> stack = new ArrayList<>(castingImage.getStack());
            var exitDirsSet = this.possibleExitDirections(blockPos, blockState, serverWorld);
            exitDirsSet.remove(direction.method_10153());
            var exits = exitDirsSet.stream().map((dir) -> this.exitPositionFromDirection(blockPos, dir)).toList();

            var storages = CircleHelper.INSTANCE.getLists(circleCastEnv);
            if (storages.isEmpty()) {
                this.fakeThrowMishap(
                        blockPos, blockState, castingImage, circleCastEnv,
                        new MishapNoStorageLoci(blockPos)
                );
                return new ControlFlow.Stop();
            }

            var entities = CircleHelper.INSTANCE.getStorage(circleCastEnv);
            if (entities.size() * 16 <= storages.size()) { // Woops! No storage
                stack.add(new BooleanIota(false));
                return new ControlFlow.Continue(
                        castingImage.copy(stack, castingImage.getParenCount(), castingImage.getParenthesized(), castingImage.getEscapeNext(), castingImage.getOpsConsumed(), castingImage.getUserData()),
                        exits);
            }

            // Idk mate, this is what Hexal Does
            var container = new class_1715(new AutocraftingMenu(), 3, 3);
            Map<ItemVariant, Integer> shoppingList = new HashMap<>();
            for (int i = 0; i < 9; i++) {
                var temp = craftingLoci.getStack(i);
                ItemVariant variant = ItemVariant.of(temp);
                if (!storages.containsKey(variant)) { // If we cant find the variant, kill the search and push false
                    stack.add(new BooleanIota(false));
                    return new ControlFlow.Continue(
                            castingImage.copy(stack, castingImage.getParenCount(), castingImage.getParenthesized(), castingImage.getEscapeNext(), castingImage.getOpsConsumed(), castingImage.getUserData()),
                            exits);
                }

                // If we know the item is there, increment it, else, add it
                if (shoppingList.containsKey(variant)) shoppingList.put(variant, shoppingList.get(variant) + 1);
                else shoppingList.put(variant, 1);
                container.method_5447(i, temp);
            }

            var recipeOpt = serverWorld.method_8433().method_8132(class_3956.field_17545, container, serverWorld);

            if (recipeOpt.isEmpty()) { // If a recipe was not found, then yadadada
                stack.add(new BooleanIota(false));
                return new ControlFlow.Continue(
                        castingImage.copy(stack, castingImage.getParenCount(), castingImage.getParenthesized(), castingImage.getEscapeNext(), castingImage.getOpsConsumed(), castingImage.getUserData()),
                        exits);
            }

            for (var pair : shoppingList.entrySet()) { // Here we check if what we want is less than what we have
                if (pair.getKey().isBlank())
                    continue;
                var slot = storages.get(pair.getKey());
                if (slot.getCount() < pair.getValue()) { // If so, kill and push false
                    stack.add(new BooleanIota(false));
                    return new ControlFlow.Continue(
                            castingImage.copy(stack, castingImage.getParenCount(), castingImage.getParenthesized(), castingImage.getEscapeNext(), castingImage.getOpsConsumed(), castingImage.getUserData()),
                            exits);
                } else {
                            slot.getStorageLociEntity().removeStack(
                            slot.getStorageLociEntity().getSlot(slot.getItem()),
                            pair.getValue());
                }
            }

            var outputItem = recipeOpt.get().method_8116(container, serverWorld.method_30349());
            var remainderItems = recipeOpt.get().method_8111(container);

            CircleHelper.INSTANCE.storeItems(circleCastEnv, outputItem);
            for (var item : remainderItems) {
                CircleHelper.INSTANCE.storeItems(circleCastEnv, item);
            }

            serverWorld.method_8396(null, blockPos, IMPETUS_REDSTONE_DING, class_3419.field_15245, 1.0F, 1F);
            stack.add(new BooleanIota(true));
            return new ControlFlow.Continue(
                    castingImage.copy(stack, castingImage.getParenCount(), castingImage.getParenthesized(), castingImage.getEscapeNext(), castingImage.getOpsConsumed(), castingImage.getUserData()),
                    exits);
        } else {
            return new ControlFlow.Stop();
        }
    }


    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CraftingLociEntity(pos,state);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        } else {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof CraftingLociEntity loci) {
                player.method_17355(loci);
            }
            return class_1269.field_21466;
        }
    }

    @Override
    public class_1304 method_7685() {
        return class_1304.field_6169;
    }

    // Ok so, no clue why Hexal does it this way, but we are just going to copy what it does (and Hexal copies AE2 lmao)
    // https://github.com/Talia-12/Hexal/blob/main/Common/src/main/java/ram/talia/hexal/common/casting/actions/spells/motes/OpCraftMote.kt
    public static class AutocraftingMenu extends class_1703 {
        public AutocraftingMenu() {super(null, 0);}
        @Override
        public class_1799 method_7601(class_1657 player, int slot) {return class_1799.field_8037;}
        @Override
        public boolean method_7597(class_1657 player) {return false;}
    }
}
