package org.sophia.slate_work.blocks;

import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import org.sophia.slate_work.blocks.entities.HotbarLociEntity;

import static at.petrak.hexcasting.common.blocks.circles.BlockSlate.*;
import static at.petrak.hexcasting.common.blocks.circles.BlockSlate.AABB_NORTH_WALL;
import static at.petrak.hexcasting.common.blocks.circles.BlockSlate.AABB_SOUTH_WALL;
import static at.petrak.hexcasting.common.blocks.circles.BlockSlate.AABB_WEST_WALL;

public class HotbarLoci extends AbstractSlate implements class_2343 {
    public HotbarLoci(class_2251 p_49795_) {
        super(p_49795_);
    }

    private static final class_265 DOWN_AB = class_259.method_1084(AABB_FLOOR,
            BlockSlate.method_9541(1,1,1,15,4,15));
    private static final class_265 UP_AB = class_259.method_1084(AABB_CEILING,
            BlockSlate.method_9541(1,12,1,15,15,15));
    private static final class_265 EAST_AB = class_259.method_1084(AABB_EAST_WALL,
            BlockSlate.method_9541(1,1,1,4,15,15));
    private static final class_265 WEST_AB = class_259.method_1084(AABB_WEST_WALL,
            BlockSlate.method_9541(12,1,1,15,15,15));
    private static final class_265 NORTH_AB = class_259.method_1084(AABB_NORTH_WALL,
            BlockSlate.method_9541(1,1,12,15,15,15));
    private static final class_265 SOUTH_AB = class_259.method_1084(AABB_SOUTH_WALL,
            BlockSlate.method_9541(1,1,1,15,15,4));

    @Override
    public ControlFlow acceptControlFlow(CastingImage imageIn, CircleCastEnv env, class_2350 enterDir, class_2338 pos, class_2680 bs, class_3218 world) {
        if (world.method_8321(pos) instanceof HotbarLociEntity){
            var data =imageIn.getUserData().method_10553();
            data.method_10566("hotbar_loci", class_2512.method_10692(pos));
            var exitDirsSet = this.possibleExitDirections(pos, bs, world);
            exitDirsSet.remove(enterDir.method_10153());
            var exitDirs = exitDirsSet.stream().map((dir) -> this.exitPositionFromDirection(pos, dir));

            return new ControlFlow.Continue(
                    imageIn.copy(imageIn.getStack(), imageIn.getParenCount(), imageIn.getParenthesized(),
                            imageIn.getEscapeNext(), imageIn.getOpsConsumed(), data), exitDirs.toList());
        }
        return new ControlFlow.Stop();
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new HotbarLociEntity(pos, state);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(FACING)){
            case field_11043 -> NORTH_AB;
            case field_11035 -> SOUTH_AB;
            case field_11039 -> WEST_AB;
            case field_11034 -> EAST_AB;
            case field_11036 -> DOWN_AB;
            case field_11033 -> UP_AB;
        };
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!newState.method_27852(state.method_26204())) {
            if (world instanceof class_3218 sWorld && sWorld.method_8321(pos) instanceof HotbarLociEntity entity) {
                class_1264.method_5451(world, pos, entity.getInv());
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        } else {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof HotbarLociEntity loci) {
                player.method_17355(loci);
            }
            return class_1269.field_21466;
        }
    }
}
