package org.sophia.slate_work.blocks;

import at.petrak.hexcasting.api.addldata.ADIotaHolder;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.iota.ListIota;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import org.sophia.slate_work.blocks.entities.MacroLociEntity;
import org.sophia.slate_work.casting.mishap.MishapSpellCircleReadableFocus;

import static at.petrak.hexcasting.common.blocks.circles.BlockSlate.*;
import static at.petrak.hexcasting.common.blocks.circles.BlockSlate.AABB_NORTH_WALL;
import static at.petrak.hexcasting.common.blocks.circles.BlockSlate.AABB_SOUTH_WALL;
import static at.petrak.hexcasting.common.blocks.circles.BlockSlate.AABB_WEST_WALL;

@SuppressWarnings("deprecation")
public class MacroLoci extends AbstractSlate implements class_2343 {

    private static final class_265 DOWN_AB = class_259.method_1084(AABB_FLOOR,
            BlockSlate.method_9541(2,1,2,14,4,14));
    private static final class_265 UP_AB = class_259.method_1084(AABB_CEILING,
            BlockSlate.method_9541(2,12,2,14,15,14));
    private static final class_265 EAST_AB = class_259.method_1084(AABB_EAST_WALL,
            BlockSlate.method_9541(1,2,2,4,14,14));
    private static final class_265 WEST_AB = class_259.method_1084(AABB_WEST_WALL,
            BlockSlate.method_9541(12,2,2,15,14,14));
    private static final class_265 NORTH_AB = class_259.method_1084(AABB_NORTH_WALL,
            BlockSlate.method_9541(2,2,12,14,14,15));
    private static final class_265 SOUTH_AB = class_259.method_1084(AABB_SOUTH_WALL,
            BlockSlate.method_9541(2,2,1,14,14,4));

    public static final class_2746 FOCUS = class_2746.method_11825("focus");
    public MacroLoci(class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590(this.field_10647.method_11664().method_11657(FOCUS,false).method_11657(ENERGIZED, false));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(FOCUS);
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return switch (pState.method_11654(FACING)){
            case field_11043 -> NORTH_AB;
            case field_11035 -> SOUTH_AB;
            case field_11039 -> WEST_AB;
            case field_11034 -> EAST_AB;
            case field_11036 -> DOWN_AB;
            case field_11033 -> UP_AB;
        };
    }

    @Override
    public ControlFlow acceptControlFlow(CastingImage castingImage, CircleCastEnv circleCastEnv, class_2350 direction, class_2338 blockPos, class_2680 blockState, class_3218 serverWorld) {
        var exitDirsSet = this.possibleExitDirections(blockPos, blockState, serverWorld);
        exitDirsSet.remove(direction.method_10153());
        var exitDirs = exitDirsSet.stream().map((dir) -> this.exitPositionFromDirection(blockPos, dir));
        var data = castingImage.getUserData().method_10553();

        if (serverWorld.method_8321(blockPos) instanceof MacroLociEntity loci) {
            class_2487 macro = new class_2487();
            ADIotaHolder holder = IXplatAbstractions.INSTANCE.findDataHolder(loci.method_5438(0));

            if (holder == null){
                this.fakeThrowMishap(blockPos, blockState, castingImage, circleCastEnv,
                    new MishapSpellCircleReadableFocus(blockPos));
                return new ControlFlow.Stop();
            }
            if (holder.readIota(serverWorld) == null){
                this.fakeThrowMishap(blockPos, blockState, castingImage, circleCastEnv,
                    new MishapSpellCircleReadableFocus(blockPos));
                return new ControlFlow.Stop();
            }

           if (!(holder.readIota(serverWorld) instanceof ListIota || holder.readIota(serverWorld).executable())){
                this.fakeThrowMishap(blockPos, blockState, castingImage, circleCastEnv,
                        new MishapSpellCircleReadableFocus(blockPos));
                return new ControlFlow.Stop();
            }

            macro.method_10566("macro", holder.readIotaTag());
            var pattern = loci.getPattern().serializeToNBT();
            macro.method_10566("pattern", pattern);

            var macros = data.method_10554("macros", class_2520.field_33260);
            int i = 0;
            for (var z : macros){
                class_2487 compound = (class_2487) z;
                if (PatternIota.deserialize(compound.method_10580("pattern")).getPattern().anglesSignature().equals(loci.getPattern().anglesSignature())){
                    macros.method_10536(i);
                    break;
                }
                i++;
            }
            macros.add(macro);
            data.method_10566("macros", macros);
        }
        return new ControlFlow.Continue(
                castingImage.copy(castingImage.getStack(), castingImage.getParenCount(), castingImage.getParenthesized(),
                        castingImage.getEscapeNext(), castingImage.getOpsConsumed(), data),
                exitDirs.toList());
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        var entity = world.method_8321(pos);
        if (entity instanceof MacroLociEntity loci && newState.method_26215()){
            if (!loci.method_5438(0).method_7960()){
                world.method_8649(new class_1542(world,
                        pos.method_10263(), pos.method_10264(),  pos.method_10260(), loci.method_5438(0)));
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    // Code mostly gotten from the amazing Sam
    // https://github.com/SamsTheNerd/ducky-periphs/blob/56252d6ab19f612a15ad9010a6e64661889ea4b0/common/src/main/java/com/samsthenerd/duckyperiphs/hexcasting/FocalPortBlockEntity.java#L312
    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.method_8321(pos) instanceof MacroLociEntity loci){
            if (loci.method_5442()){ // If the Loci is empty...
                class_1799 stack = player.method_5998(hand);
                if (loci.method_5437(0,stack)){ // And the item is valid...
                    loci.method_5447(0,stack.method_7972()); // Set the stack of the Loci
                    world.method_8501(pos,state.method_11657(FOCUS,true));
                    player.method_6122(hand,class_1799.field_8037); // and clear the player's hand
                    loci.method_5431();
                }
            } else { // if the Loci has a focus in it already...
                class_1799 installed = loci.method_5441(0).method_7972();
                class_1799 held = player.method_5998(hand);

                if (loci.method_5437(0,held)){ // If the item is valid...
                    loci.method_5447(0,held); // Set the stack of the Loci
                    world.method_8501(pos,state.method_11657(FOCUS,true));
                    player.method_6122(hand,class_1799.field_8037); // and clear the player's hand
                    loci.method_5431();
                } else {
                    world.method_8501(pos,state.method_11657(FOCUS,false));
                }
                if (!player.method_31548().method_7394(installed)){ // If we *can't* put the old stack back into the player's Inv
                    player.method_7328(installed,false); // Then drop the item
                }
                return class_1269.method_29236(world.field_9236);
            }
        }
        return class_1269.field_5812;
    }


    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MacroLociEntity(pos,state);
    }
}
