package org.sophia.slate_work.blocks;

import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import org.sophia.slate_work.casting.mishap.MishapSpellCircleInvalidIota;
import org.sophia.slate_work.casting.mishap.MishapSpellCircleNotEnoughArgs;

import java.util.ArrayList;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_3218;
import net.minecraft.class_3726;

public class MuteLoci extends AbstractSlate {
    public static final class_2753 FACING = class_2741.field_12525;

    public MuteLoci(class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590(this.field_10647.method_11664().method_11657(ENERGIZED, false).method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, false));
    }

    @Override
    public ControlFlow acceptControlFlow(CastingImage castingImage, CircleCastEnv circleCastEnv, class_2350 direction,
                                         class_2338 blockPos, class_2680 blockState, class_3218 serverWorld) {
        ArrayList<Iota> stack = new ArrayList<>(castingImage.getStack());
        var data = castingImage.getUserData().method_10553();

        var exitDirsSet = this.possibleExitDirections(blockPos, blockState, serverWorld);
        exitDirsSet.remove(direction.method_10153());
        var exits = exitDirsSet.stream().map((dir) -> this.exitPositionFromDirection(blockPos, dir)).toList();

        if (stack.isEmpty()) {
            this.fakeThrowMishap(
                    blockPos, blockState, castingImage, circleCastEnv,
                    new MishapSpellCircleNotEnoughArgs(1,0,blockPos)
            );
            return new ControlFlow.Stop();
        }

        var last = stack.get(stack.size() -1);
        stack.remove(stack.size() -1);
        if (!(last instanceof DoubleIota)) {
            this.fakeThrowMishap(
                    blockPos, blockState, castingImage, circleCastEnv,
                    MishapSpellCircleInvalidIota.ofType(last, 0, "double", blockPos)
            );
            return new ControlFlow.Stop();
        }

        var volume = ((DoubleIota) last).getDouble();
        if (volume > 1 || volume < 0) {
            this.fakeThrowMishap(
                    blockPos, blockState, castingImage, circleCastEnv,
                    MishapSpellCircleInvalidIota.of(last, 0, "double.between", blockPos,1, 0)
            );
            return new ControlFlow.Stop();
        }

        // Everything *should* be valid now

        if (volume == 1){
            data.method_10556("mute", false);
        } else {
            data.method_10556("mute", true);
            data.method_10548("volume", (float) volume);
        }
        return new ControlFlow.Continue(
                castingImage.copy(stack, castingImage.getParenCount(), castingImage.getParenthesized(),
                        castingImage.getEscapeNext(), castingImage.getOpsConsumed(), data), exits);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(FACING)){
            case field_11033  -> method_9541(0.0, 16 -3.0, 0.0, 16.0, 16.0, 16.0);
            case field_11036 -> method_9541(0.0,0.0,0.0,16.0,3.0,16.0);
            case field_11043 -> method_9541(0.0, 0.0, 16 -3.0, 16.0, 16.0, 16.0);
            case field_11035 -> method_9541(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
            case field_11039 -> method_9541(16 -3.0, 0.0, 0.0, 16.0, 16.0, 16.0);
            case field_11034 -> method_9541(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);
        };
    }
}
