package org.sophia.slate_work.blocks;

import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import org.sophia.slate_work.casting.mishap.MishapSpellCircleInvalidIota;
import org.sophia.slate_work.casting.mishap.MishapSpellCircleNotEnoughArgs;
import org.sophia.slate_work.misc.ICircleSpeedValue;

import java.util.ArrayList;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_5819;

@SuppressWarnings("deprecation")
public class RedstoneLoci extends AbstractSlate {
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2758 POWER = class_2741.field_12511;

    @Override
    public class_2350 normalDir(class_2338 pos, class_2680 bs, class_1937 world, int recursionLeft) {
        return super.normalDir(pos, bs, world, recursionLeft);
    }

    public RedstoneLoci(class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590(this.field_10647.method_11664().method_11657(POWER, 0).method_11657(POWERED, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(POWER, POWERED);
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }

    @Override
    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return state.method_11654(POWERED) && state.method_11654(FACING).method_10153() != direction ? state.method_11654(POWER) : 0;
    }

    @Override
    public int method_9572(class_2680 pState, class_1937 pLevel, class_2338 pPos) {
        return pState.method_11654(POWERED) ? 15 : 0;
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        world.method_8652(pos, state.method_11657(POWERED, false), class_2248.field_31028);
        this.updateNeighbors(world, pos, state);
    }

    private void updateNeighbors(class_1937 world, class_2338 pos, class_2680 bs){
        world.method_8452(pos, this);
        world.method_8452(pos.method_10093(bs.method_11654(FACING).method_10153()), this);
    }

    private void scheduleTick(class_1936 world, class_2338 pos, int time) {
        if (!world.method_8608()) {
            world.method_39279(pos, this, time);
        }
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        // Dont do anything!
    }

    @Override
    public ControlFlow acceptControlFlow(CastingImage imageIn, CircleCastEnv env, class_2350 enterDir, class_2338 pos, class_2680 bs, class_3218 world) {
        ArrayList<Iota> stack = new ArrayList<>(imageIn.getStack());

        if (stack.isEmpty()) {
            this.fakeThrowMishap(
                    pos, bs, imageIn, env,
                    new MishapSpellCircleNotEnoughArgs(1,0, pos)
            );
            return new ControlFlow.Stop();
        }

        var last = stack.get(stack.size() -1);
        stack.remove(stack.size() -1);
        if (!(last instanceof DoubleIota)) {
            this.fakeThrowMishap(
                    pos, bs, imageIn, env,
                    MishapSpellCircleInvalidIota.ofType(last, 0, "int", pos)
            );
            return new ControlFlow.Stop();
        }
        var power = (int) ((DoubleIota) last).getDouble();
        if (power > 15 || power < 0) {
            this.fakeThrowMishap(
                    pos, bs, imageIn, env,
                    MishapSpellCircleInvalidIota.of(last, 0, "int.between", pos,15, 0)
            );
            return new ControlFlow.Stop();
        }
        var newbs = bs.method_11657(POWER, power).method_11657(POWERED, true);
        world.method_8501(pos, newbs);
        this.updateNeighbors(world, pos, newbs);

        var imp = env.getImpetus();
        if (imp != null && imp.getExecutionState() != null){
            this.scheduleTick(world, pos,
                    ((ICircleSpeedValue) env.getImpetus().getExecutionState()).slate_work$getTickSpeed()
            );
        }

        var exitDirsSet = this.possibleExitDirections(pos, bs, world);
        exitDirsSet.remove(enterDir.method_10153());
        var exits = exitDirsSet.stream().map((dir) -> this.exitPositionFromDirection(pos, dir)).toList();

        return new ControlFlow.Continue(imageIn.copy(stack, imageIn.getParenCount(), imageIn.getParenthesized(),
                imageIn.getEscapeNext(), imageIn.getOpsConsumed(), imageIn.getUserData()), exits);
    }


    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return switch (pState.method_11654(FACING)){
            case field_11033 -> method_9541(0.0, 16 -5.0, 0.0, 16.0, 16.0, 16.0);
            case field_11036 -> method_9541(0.0,0.0,0.0,16.0,5.0,16.0);
            case field_11043 -> method_9541(0.0, 0.0, 16 -5.0, 16.0, 16.0, 16.0);
            case field_11035 -> method_9541(0.0, 0.0, 0.0, 16.0, 16.0, 5.0);
            case field_11039 -> method_9541(16 -5.0, 0.0, 0.0, 16.0, 16.0, 16.0);
            case field_11034 -> method_9541(0.0, 0.0, 0.0, 5.0, 16.0, 16.0);
        };
    }
}
