package org.sophia.slate_work.blocks;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import net.minecraft.block.*;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_6088;
import org.jetbrains.annotations.Nullable;
import org.sophia.slate_work.blocks.entities.SaveLociEntity;
import org.sophia.slate_work.registries.BlockRegistry;

import java.util.EnumSet;

import static at.petrak.hexcasting.common.blocks.circles.BlockSlate.AABB_FLOOR;
import static at.petrak.hexcasting.common.blocks.circles.BlockSlate.FACING;

public class SaveLoci extends BlockCircleComponent implements class_2343 {
    public static final class_2746 TOP_PART = class_2741.field_12519;
    public static final class_2753 HORIZONTAL = class_2741.field_12481;

    public SaveLoci(class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590(this.field_10647.method_11664().method_11657(ENERGIZED, false).method_11657(TOP_PART, false).method_11657(HORIZONTAL, class_2350.field_11043));
    }

    @Override
    public class_2350 normalDir(class_2338 blockPos, class_2680 blockState, class_1937 world, int i) {
        return class_2350.field_11036;
    }

    @Override
    public float particleHeight(class_2338 blockPos, class_2680 blockState, class_1937 world) {
        return 0;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(TOP_PART, FACING);
    }

    @Override
    public ControlFlow acceptControlFlow(CastingImage castingImage, CircleCastEnv circleCastEnv, class_2350 direction, class_2338 blockPos, class_2680 blockState, class_3218 serverWorld) {
        class_2338 entityPos = blockPos;
        if (blockState.method_11654(TOP_PART)) entityPos = blockPos.method_10074();
        if (!serverWorld.method_8320(entityPos.method_10084()).method_27852(BlockRegistry.SAVE_LOCI)) return new ControlFlow.Stop(); // Carry on is now *BANNED*
        if (serverWorld.method_8321(entityPos) instanceof SaveLociEntity entity) {
            var newCastingImage = entity.swapSave(castingImage, serverWorld);

            var exitDirsSet = this.possibleExitDirections(blockPos, blockState, serverWorld);
            exitDirsSet.remove(direction.method_10153());
            var exits = exitDirsSet.stream().map((dir) -> this.exitPositionFromDirection(blockPos, dir)).toList();
            return new ControlFlow.Continue(newCastingImage, exits);
        }
        return new ControlFlow.Stop();
    }

    @Override
    public boolean canEnterFromDirection(class_2350 direction, class_2338 blockPos, class_2680 blockState, class_3218 serverWorld) {
        return direction != class_2350.field_11033;
    }

    @Override
    public EnumSet<class_2350> possibleExitDirections(class_2338 blockPos, class_2680 blockState, class_1937 world) {
        EnumSet<class_2350> z = EnumSet.allOf(class_2350.class);
        z.remove(class_2350.field_11036);
        return z;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int offset = 0;
        if (state.method_11654(TOP_PART)) offset = -1;
        return class_259.method_1084(AABB_FLOOR,
                method_9541(1,1,1,15,31,15)).method_1096(0,offset,0);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.field_9236) {
            class_2338 blockPos = pos.method_10084();
            world.method_8652(blockPos, state.method_11657(TOP_PART, true), class_2248.field_31036);
            world.method_8408(pos, class_2246.field_10124);
            state.method_30101(world, pos, class_2248.field_31036);
        }
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_22347(pos.method_10084());
    }

    @Override
    public class_2680 method_9598(class_2680 pState, class_2470 pRot) {
        return pState.method_11657(FACING, pRot.method_10503(pState.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pState.method_26186(pMirror.method_10345(pState.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        var dir = pContext.method_8042();
        if (pContext.method_8036() != null && !pContext.method_8036().method_21751()) {
            dir = dir.method_10153();
        }
        return this.method_9564().method_11657(HORIZONTAL, dir);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!state.method_27852(newState.method_26204()) || state.method_11654(FACING) != newState.method_11654(FACING)){
            if (!world.field_9236) {
                class_2338 blockPos;
                if (state.method_11654(TOP_PART)) blockPos = pos.method_10074();
                    else blockPos = pos.method_10084();

                class_2680 blockState = world.method_8320(blockPos);
                if (blockState.method_27852(this)) {
                    world.method_8652(blockPos, class_2246.field_10124.method_9564(), class_2248.field_31036 | class_2248.field_31032);
                    world.method_8444(null, class_6088.field_31144, blockPos, class_2248.method_9507(blockState));
                }
            }
        }
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (!state.method_11654(TOP_PART))
            return new SaveLociEntity(pos, state);
        return null;
    }
}

