package org.sophia.slate_work.blocks;

import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.misc.MediaConstants;
import net.minecraft.class_1304;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_5151;
import org.jetbrains.annotations.Nullable;
import org.sophia.slate_work.blocks.entities.SentinelLociEntity;
import org.sophia.slate_work.casting.mishap.MishapSpellCircleMedia;

import static at.petrak.hexcasting.common.blocks.circles.BlockSlate.*;

public class SentinelLoci extends AbstractSlate implements class_2343, class_5151 {
    public SentinelLoci(class_2251 settings) {
        super(settings);
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SentinelLociEntity(pos, state);
    }

    @Override
    public ControlFlow acceptControlFlow(CastingImage castingImage, CircleCastEnv circleCastEnv, class_2350 direction, class_2338 blockPos, class_2680 blockState, class_3218 serverWorld) {
        var exitDirsSet = this.possibleExitDirections(blockPos, blockState, serverWorld);
        exitDirsSet.remove(direction.method_10153());
        var exitDirs = exitDirsSet.stream().map((dir) -> this.exitPositionFromDirection(blockPos, dir));
        var data = castingImage.getUserData().method_10553();

        if (!blockState.method_11654(ENERGIZED)) {
            var extracted = circleCastEnv.extractMedia(MediaConstants.DUST_UNIT / 100, false);
            if (0L != extracted) {
                this.fakeThrowMishap(
                        blockPos, blockState, castingImage, circleCastEnv,
                        new MishapSpellCircleMedia(MediaConstants.DUST_UNIT / 100, blockPos)
                );
                return new ControlFlow.Stop();
            }
        }

        var sentTime = data.method_10537("sentinel_time");
        if (sentTime == 0L){
            // To make sure this is never 0
            data.method_10544("sentinel_time", circleCastEnv.getWorld().method_8510());
        }

        var entity = serverWorld.method_8321(blockPos);
        if (entity instanceof SentinelLociEntity sent){
            var list = data.method_10554("sentinel_loci", class_2520.field_33260);
            var compound = new class_2487();
            compound.method_10566("pos",class_2512.method_10692(sent.method_11016()));
            compound.method_10544("count", 0);
            list.add(compound);
            data.method_10566("sentinel_loci",list);
            return new ControlFlow.Continue(
                    castingImage.copy(castingImage.getStack(),castingImage.getParenCount(),castingImage.getParenthesized(),
                            castingImage.getEscapeNext(),castingImage.getOpsConsumed(),data), exitDirs.toList()
            );
        }

        return new ControlFlow.Stop();
    }

    private static final class_265 UP_AB = class_259.method_17786(AABB_FLOOR,
            method_9541(6,1,6,10,7,10),
            method_9541(1,7,1,15,9,15));
    private static final class_265 DOWN_AB = class_259.method_17786(AABB_CEILING,
            method_9541(6,16-7,6,10,16-1,10),
            method_9541(1,16-9,1,15,16-7,15));
    private static final class_265 EAST_AB = class_259.method_17786(AABB_EAST_WALL,
            method_9541(1,6,6,7,10,9),
            method_9541(7,1,1,9,15,15));
    private static final class_265 WEST_AB = class_259.method_17786(AABB_WEST_WALL,
            method_9541(16-7,6,6,16-1,10,9),
            method_9541(16-9,1,1,16-7,15,15));
    private static final class_265 SOUTH_AB = class_259.method_17786(AABB_SOUTH_WALL,
            method_9541(6,6,1,9,10,7),
            method_9541(1,1,7,15,15,9));
    private static final class_265 NORTH_AB = class_259.method_17786(AABB_NORTH_WALL,
            method_9541(6,6,16-7,9,10,16-1),
            method_9541(1,1,16-9,15,15,16-7));

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(FACING)) {
            case field_11033 -> DOWN_AB;
            case field_11036 -> UP_AB;
            case field_11043 -> NORTH_AB;
            case field_11035 -> SOUTH_AB;
            case field_11039 -> WEST_AB;
            case field_11034 -> EAST_AB;
        };
    }

    @Override
    public class_1304 method_7685() {
        return class_1304.field_6169;
    }
}
